﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" meta:resourcekey="PageResource1" %>

<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>
<script runat="server">
//@Override this is suggested by Microsoft, overriding the initialize culture function (that is
//automatically called by the aspx.
//Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
//(English).
protected override void InitializeCulture()
{
    HttpCookie lang = Request.Cookies["siteLanguage"]; 
    
    String selectedLanguage = (lang != null) ? lang.Value : "en";
    UICulture = selectedLanguage ;
    Culture = selectedLanguage ;

    Thread.CurrentThread.CurrentCulture = 
        CultureInfo.CreateSpecificCulture(selectedLanguage);
    Thread.CurrentThread.CurrentUICulture = new 
        CultureInfo(selectedLanguage);
    base.InitializeCulture();
}
</script>
<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).
    
    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<%--view template starts here (will be appended inside a row-fluid)--%>

<script id="main_template" type="text/x-handlebars-template">

    <style type="text/css">

        .help-center-menu {
          width: 228px;
          margin: 30px 0 0;
          padding: 0;
          background-color: #fff;
          -webkit-border-radius: 6px;
             -moz-border-radius: 6px;
                  border-radius: 6px;
          -webkit-box-shadow: 0 1px 4px rgba(0,0,0,.065);
             -moz-box-shadow: 0 1px 4px rgba(0,0,0,.065);
                  box-shadow: 0 1px 4px rgba(0,0,0,.065);
        }
        .help-center-menu > li > a {
          display: block;
          width: 190px;
          margin: 0 0 -1px;
          padding: 8px 14px;
          border: 1px solid #e5e5e5;
        }
        .help-center-menu > li:first-child > a {
          -webkit-border-radius: 6px 6px 0 0;
             -moz-border-radius: 6px 6px 0 0;
                  border-radius: 6px 6px 0 0;
        }
        .help-center-menu > li:last-child > a {
          -webkit-border-radius: 0 0 6px 6px;
             -moz-border-radius: 0 0 6px 6px;
                  border-radius: 0 0 6px 6px;
        }
        .help-center-menu > .active > a {
          position: relative;
          z-index: 2;
          padding: 9px 15px;
          border: 0;
          text-shadow: 0 1px 0 rgba(0,0,0,.15);
          -webkit-box-shadow: inset 1px 0 0 rgba(0,0,0,.1), inset -1px 0 0 rgba(0,0,0,.1);
             -moz-box-shadow: inset 1px 0 0 rgba(0,0,0,.1), inset -1px 0 0 rgba(0,0,0,.1);
                  box-shadow: inset 1px 0 0 rgba(0,0,0,.1), inset -1px 0 0 rgba(0,0,0,.1);
        }

            .help-center-menu.affix {
                top:30px;
            }

    </style>

    <div class="container">
        <div class="row-fluid">
            <div class="span5">
                <h3><asp:Localize runat="server" meta:resourcekey="helpcenter_title" /></h3>
            </div>
        </div>
        <div class="row-fluid">
            <div id="side_menu_container" class="span3">
                <ul id="side_menu" class="nav nav-list help-center-menu">
                    {{#each menuitems}}
                        <li {{#unless enabled}}class="disabled"{{/unless}} id="{{id}}"><a {{#if enabled}} href="{{url}}" {{/if}}>{{name}}</a></li>
                    {{/each}}
                </ul>
            </div>
            <div id="help_content_container" class="span9">
                <div id="help_content" class="span12">
                    
                </div>
            </div>
        </div>
    </div>

</script>

<script id="items_overview_template" type="text/x-handlebars-template">
    <%--<ul id="overview_tabs" class="nav nav-tabs">
        <li class="active"><a href="#section1">Subsection 1</a></li>
        <li><a href="#section2">Subsection 2</a></li>
    </ul>
    <div class="tab-content">
        <div id="section1" class="tab-pane active">--%>
            {{#each itemsrows}}
            <div class="row-fluid">
                <ul class="thumbnails">
                    {{#each thumbs}}
                    <li class="span4">
                        <div class="thumbnail">
                            <img alt="260x180" style="width: 260px; height: 180px;" src="{{imgURL}}">
                            <div class="caption">
                                <h4>{{title}}</h4>
                                <p>{{description}}</p>
                                <p><a href="{{url}}" class="btn btn-primary">Ver tutorial</a></p>
                            </div>
                        </div>
                    </li>
                    {{/each}}
                </ul>
            </div>
            {{/each}}
        <%--</div>
        <div id="section2" class="tab-pane"></div>
    </div>--%>
</script>

<script id="watch_template" type="text/x-handlebars-template">
    <div style="margin-bottom:10px;" class="row-fluid">        
        <a href="{{backToListURL}}" class="btn"><i class="icon-th"></i> Volver a la lista</a>
    </div>
    <%--<div class="row-fluid">
        <div class="movie-wrapper span12">
            <div style="height:500px;" class="span10 offset1">
                <a id="player" href="{{path}}"></a>
            </div>
        </div>

        <script type="text/javascript">
            flowplayer("player", "<%= ResolveUrl("~/assets/libs/flowplayer/flowplayer-3.2.16.swf") %>"); 
        </script>

    </div>--%>
    <div class="row-fluid">
        <div class="movie-wrapper span12">
            <div style="margin:0 auto; height:{{height}}px; width:{{width}}px;">
                <object 
                    classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000" 
                    codebase="http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=7,0,19,0" 
                    width="{{width}}" 
                    height="{{height}}"
                    ID="sf" 
                    type="application/x-shockwave-flash"
                    VIEWASTEXT>
                    <param name="movie" value="{{path}}" />
                    <param name="menu" value="false" />
                    <param name="quality" value="high" />
                    <param name="wmode" value="window" />
                    <param name="allowScriptAccess" value="always" />
                    <param name="allowFullScreen" value="true" />
                    <embed src="{{path}}" quality="high" name="sf" allowScriptAccess="always" allowFullScreen="true" pluginspage="http://www.macromedia.com/go/getflashplayer" type="application/x-shockwave-flash" width="{{width}}" height="{{height}}"></embed>
                </object>
            </div>
        </div>
    </div>

</script>