﻿//SCREEN-BOILERPLATE

//this boilerplate builds screens that are gonna be shown in the <div class="content"> tag of our main HTML.
//do not build app components with this boilerplate, only screens (reports)

define([
  // Application variable, always include it to have access to app methods.
  "app",

  //templates-loader: this loads templates async.
  "js/templates-loader",

  "modules/modal"

],

function (app, T, Modal) {

    //replace all "ViewName" with your view's name.
    var ViewName = { Model: {}, Views: {} }

    ViewName.Model = Backbone.Model.extend({
        defaults: {
            procedure: ''
        }
    });

    ViewName.Views.Main = Backbone.View.extend({
        template: "help-center"
        , id: "help-center"
        , title: ""
        //default not cacheable, change this if you want the view to be cacheable
        // if the view is set as cacheable should also have a refresh method to reset the view without erasing the DOM.
        , isCacheable: true
        , initialize: function () {
            if (this.options.viewParams) {
            }

            var model = new ViewName.Model({
                procedure: "dbo.procedureName"
            });

            this.model = model;

            this.bindEvents();
            _.bindAll(this);
        },

        events: {
        }, 

        render: function (container, viewParams) {
            var that = this;
            var thatContainer = container;
            this.options.container = container; 
            this.options.MYREFERENCES = {};
            
            this.refresh(viewParams);

            thatContainer.append(this.$el); 

        }

        , refresh: function (viewparams) {
            try {

                if (!viewparams.action) {
                    viewparams.action = "overview";
                    viewparams.item = "trending"; 
                }

                var that = this; 
                switch (viewparams.action) {

                    case "overview":
                        this._renderContentWithSideMenu(
                            function () {
                                that.$("#side_menu > li").removeClass("active");
                                that.$("#side_menu > #" + viewparams.item).addClass("active");
                                that._renderOverview(viewparams.item);
                            }
                        ); 
                        break;
                    case "watch":
                        this._renderWatch(viewparams.item, viewparams.subitem); 
                        break; 

                }

            } catch (Error) { }
        }
        , _renderContentWithSideMenu: function (callback) {

            //the screens have a custompath, so it has to be specified in the customPath variable that is
            //then sent to the template loader.
            var customPath = "/app/screens/help-center/";
            var that = this;
            T.render.call(this, this.template, function (tmp) {

                //start: before the view is visible, but the template was already loaded (not instanced nor appended)

                var data = {
                    menuitems: [
                        { id: "trending", url: "!/help-center/overview/trending", name: "Trending", enabled: true}
                        , { id: "unifilarmap", url: "!/help-center/overview/unifilarmap", name: "Mímico", enabled: false}
                        , { id: "ihconfiguration", url: "!/help-center/overview/ihconfiguration", name: "Configuración IH", enabled:false }
                    ]
                };

                //end:

                //loading the view and appeding it to the views's $el.
                that.$el.html(tmp(data));

                that.$("#side_menu").affix({
                    offset: { top: 80 }
                });

                //start: the view was already loaded an is on a div element, but not appended to the main container
                //here you can perform anything you want DOM related, by getting the dom element via that.$el.find("#id")
                //or this.$("#id")
                callback(); 
                //end

            }, customPath, "main_template");

        }
        , _renderOverview: function (item) {

            var tutorials = {
                "trending": {
                    "create-view": {
                        title: "Crear nueva vista"
                        , description: "Crear una vista, agregar variables, editar colores y guardar."
                    }
                    , "using-tools": {
                        title: "Herramientas de Trending"
                        , description: "Aprendiendo a utilizar las herramientas del trending."
                    }
                    , "mouse-gestures": {
                        title: "Gestos con el Mouse"
                        , description: "Como hacer zoom, pan y seleccionar rango de datos con el mouse."
                    }
                    , "edit-view-and-panes": {
                        title: "Edición de vista avanzada"
                        , description: "Como editar una vista, crear nuevos paneles y modificar escalas manualmente."
                    }
                }
                , "unifilarmap": {
                    "using-tools": {
                        title: "Herramientas del mapa"
                        , description: "Aprendiendo a utilizar el mapa unifilar."
                    }
                }
            }; 

            var container = this.$("#help_content").empty(); 
            var customPath = "/app/screens/help-center/";

            T.render.call(this, this.template, function (tmp) {

                //start: before the view is visible, but the template was already loaded (not instanced nor appended)

                var data = {
                    itemsrows: [
                        //{ thumbs: [] }
                    ]
                };

                var imgBasePath = app.foldersRoot + "/tours/";
                if (tutorials[item]) {
                    var itemcount = 0;
                    var itemrow = {
                        thumbs:[]
                    };
                    for (var name in tutorials[item]) {
                        itemrow.thumbs.push({
                            title: tutorials[item][name].title
                            , imgURL: imgBasePath + item + "/" + name + "/" + "thumb.png"
                            , description: tutorials[item][name].description
                            , url: "!/help-center/watch/" + item + "/" + name
                        });
                        itemcount++;

                        if (itemcount == 3) {
                            data.itemsrows.push(_.clone(itemrow));
                            itemrow = {
                                thumbs: []
                            }
                            itemcount = 0; 
                        }
                    }
                    if (itemcount != 0) {
                        data.itemsrows.push(_.clone(itemrow));
                    }
                }

                //end:

                //loading the view and appeding it to the views's $el.
                container.html(tmp(data));

                //container.find('#overview_tabs a').click(function (e) {
                //    e.preventDefault();
                //    $(this).tab('show');
                //    return false; 
                //})

            }, customPath, "items_overview_template");

        }

        , _renderWatch: function (item, subitem) {

            var container = this.$el.empty();
            var customPath = "/app/screens/help-center/";
            var movieBasePath = app.foldersRoot + "/tours/";
            var lang = "es"; 
            var that = this; 

            T.render.call(this, this.template, function (tmp) {

                //start: before the view is visible, but the template was already loaded (not instanced nor appended)

                var data = {
                    path: movieBasePath + item + "/" + subitem + "/" + subitem + "-" + lang + ".swf"
                    , width: "956"
                    , height: "405"

                    , backToListURL: "!/help-center/overview/" + item
                };

                //end:

                //loading the view and appeding it to the views's $el.
                container.html(tmp(data));

            }, customPath, "watch_template");

        }

        , bindEvents: function () {
            //this function should be in every view that uses listenTo anywhere
            //all the model bindings or view-model binding should be here, to manage
            //the show/hide view easily
        }

        , close: function () {
            this.remove();
            this.unbind();
        }

        , show: function () {
            this.bindEvents();
            this.$el.show();
        }

        , hide: function () {
            this.$el.hide();
            this.unbind();
            this.stopListening();
        }

        , preRender: function () {
            app.models.subnavbar.setAll(false);
            app.models.subnavbar.set("subnavbar", false); 
        }

        , reRender: function (viewParams) {
            this.refresh(viewParams); 
        }
    });

    // Required, return the module for AMD compliance.
    return ViewName;

});
