﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" %>

<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>
<script runat="server">
//@Override this is suggested by Microsoft, overriding the initialize culture function (that is
//automatically called by the aspx.
//Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
//(English).
protected override void InitializeCulture()
{
    HttpCookie lang = Request.Cookies["siteLanguage"]; 
    
    String selectedLanguage = (lang != null) ? lang.Value : "en";
    UICulture = selectedLanguage ;
    Culture = selectedLanguage ;

    Thread.CurrentThread.CurrentCulture = 
        CultureInfo.CreateSpecificCulture(selectedLanguage);
    Thread.CurrentThread.CurrentUICulture = new 
        CultureInfo(selectedLanguage);
    base.InitializeCulture();
}
</script>
<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).
    
    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<%--view template starts here (will be appended inside a row-fluid)--%>

<div class="span10 offset1">
    <div class="page-header">
        <h2><asp:Localize runat="server" meta:resourcekey="main_title" /></h2>
    </div>
    <div class="row-fluid">
        <div class="span1">
            <button id="button1" class="btn"><asp:Localize runat="server" meta:resourcekey="message1" /></button>
        </div>
        <div class="span1">
            <button id="button2" class="btn"><asp:Localize runat="server" meta:resourcekey="message2" /></button>
        </div>
        <div class="span4">
            <button id="button3" class="btn btn-large btn-block"><asp:Localize runat="server" meta:resourcekey="message3" /></button>
        </div>
    </div>
    <div class="row-fluid"><div style="height:20px;"></div></div>
    <div class="row-fluid">
        <div class="span10 offset1">
            <button id="button4" class="btn btn-large btn-block"><asp:Localize runat="server" meta:resourcekey="message4" /></button>
        </div>        
    </div>
    <div class="row-fluid"><div style="height:20px;"></div></div>
    <div class="row-fluid">
        <div class="span2">
            <button id="button5" class="btn"><asp:Localize runat="server" meta:resourcekey="message5" /></button>
        </div>        
        <div class="span2 offset1">
            <button id="button6" class="btn"><asp:Localize runat="server" meta:resourcekey="message6" /></button>
        </div>        
        <div class="span2">
            <button id="button7" class="btn"><asp:Localize runat="server" meta:resourcekey="message7" /></button>
        </div>        
        <div class="span2 offset1">
            <button id="button8" class="btn"><asp:Localize runat="server" meta:resourcekey="message8" /></button>
        </div>        
    </div>

</div>