﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" meta:resourcekey="PageResource1" %>

<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>
<script runat="server">
//@Override this is suggested by Microsoft, overriding the initialize culture function (that is
//automatically called by the aspx.
//Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
//(English).
protected override void InitializeCulture()
{
    HttpCookie lang = Request.Cookies["siteLanguage"]; 
    
    String selectedLanguage = (lang != null) ? lang.Value : "en";
    UICulture = selectedLanguage ;
    Culture = selectedLanguage ;

    Thread.CurrentThread.CurrentCulture = 
        CultureInfo.CreateSpecificCulture(selectedLanguage);
    Thread.CurrentThread.CurrentUICulture = new 
        CultureInfo(selectedLanguage);
    base.InitializeCulture();
}
</script>
<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).
    
    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<%--view template starts here (will be appended inside a row-fluid)--%>

<link href="<%= ResolveUrl("~/assets/libs/js/bootstrap-datepicker/css/datepicker.css") %>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/assets/libs/js/bootstrap-timepicker/css/bootstrap-timepicker.css") %>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/assets/libs/js/bootstrap-select/bootstrap-select.css") %>" rel="stylesheet" />

<style type="text/css">
    .higher-z-index > .dropdown-menu {
        z-index:99999;
    }

        .higher-z-index > .dropdown-menu > ul {
            z-index:99999;
        }
    
            .higher-z-index > .dropdown-menu > ul > li {
                z-index:99999;
            }
</style>

<div>
    <div class="row-fluid">
        <div class="jqueryUIcontrols span12">
            <div class="input-prepend span3" style="margin-bottom:0px;margin-left:-5px;">
                <span id="datetimescope_calendar-icon-clickeable" style="cursor:pointer;" class="add-on"><i class="icon-calendar"></i></span>
                <input id="datetimescope_datePicker1" style="z-index:1001;" class="span9" type="text">
            </div>
            <div class="input-prepend span3 bootstrap-timepicker" style="margin-bottom:0px;margin-left:-5px; ">
                <span id="datetimescope_time-icon-clickeable" style="cursor:pointer;" class="add-on"><i class="icon-time"></i></span>
                <input id="datetimescope_timePicker1" style="z-index:1001;" class="span9" type="text">
            </div>
            <div class="input-append span4" style="margin-bottom:0px;margin-left:-5px;">
                <button id="datetimescope_btn_back" class="btn"><i class="icon-chevron-left"></i></button>
                <select id="datetimescope_intervalPicker1" class="selectpicker span8 higher-z-index">
                    <option value="60"><asp:Localize runat="server" meta:resourcekey="interval_1_minute" /></option>
                    <option value="900"><asp:Localize runat="server" meta:resourcekey="interval_15_minutes" /></option>
                    <option value="1800"><asp:Localize runat="server" meta:resourcekey="interval_30_minutes" /></option>
                    <option value="3600"><asp:Localize runat="server" meta:resourcekey="interval_1_hour" /></option>
                    <option value="21600"><asp:Localize runat="server" meta:resourcekey="interval_6_hours" /></option>
                    <option value="43200"><asp:Localize runat="server" meta:resourcekey="interval_12_hours" /></option>
                    <option value="86400"><asp:Localize runat="server" meta:resourcekey="interval_1_day" /></option>
                    <option value="604800"><asp:Localize runat="server" meta:resourcekey="interval_1_week" /></option>
                    <option value="2592000"><asp:Localize runat="server" meta:resourcekey="interval_1_month" /></option>
                    <%--<option value="custom"><asp:Localize runat="server" meta:resourcekey="interval_custom" /></option>--%>
                </select>
                <button id="datetimescope_btn_forward" class="btn"><i class="icon-chevron-right"></i></button>
            </div>
        </div>
    </div>
</div>