﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" meta:resourcekey="PageResource1" %>


<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>

<script runat="server">
    //@Override this is suggested by Microsoft, overriding the initialize culture function (that is
    //automatically called by the aspx.
    //Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
    //(English).
    protected override void InitializeCulture()
    {
        HttpCookie lang = Request.Cookies["siteLanguage"]; 
    
        String selectedLanguage = (lang != null) ? lang.Value : "en";
        UICulture = selectedLanguage ;
        Culture = selectedLanguage ;

        Thread.CurrentThread.CurrentCulture = 
            CultureInfo.CreateSpecificCulture(selectedLanguage);
        Thread.CurrentThread.CurrentUICulture = new 
            CultureInfo(selectedLanguage);
        base.InitializeCulture();
    }
</script>
<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).
    
    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<%--view template starts here (will be appended inside a row-fluid)--%>
    <link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/lib/backgrid.css") %>" rel="stylesheet" />
    <link href="<%= ResolveUrl("~/assets/libs/js/jstree/themes/default/style.css") %>" rel="stylesheet" />

<script id="ladle-info-widget" type="text/x-handlebars-template">      
    <link href="<%= ResolveUrl("~/app/templates/ladle-info-widget/ladle-info-widget.css") %>" rel="stylesheet" />

    <div data-bind="classes:{hide: not(WidgetTypeLadle)}">
       
        <div class="heat row-fluid"> 
            <div class="span3 left-value" >
                <h3 data-bind="text: LeftValue"></h3>
            </div>

            <div class="span9 heat-details box-height-ladle-widget">
                <h4 data-bind="text: TopValue " class="top-value"></h4>
                <h6 data-bind="text: MiddleValue"  class="middle-value"></h6>
            
                <div class="row-fluid border-top-bottom">
                    <div class="span4 border-right" >
                        <h6 data-bind="text: MiddleLeftValue" class="middle-left-value"></h6>
            
                    </div>
                    <div class="span8">
                          <h6 data-bind="text: MiddleRightValue" class="middle-right-value" ></h6>
            
                    </div>
                </div>

                <div class="row-fluid">
                    <div class="span4 bottom-left-value">
                        <span data-bind="text: BottomLeftValue"></span>
                        <span><label class="bottom-left-value-label">Heats</label></span>

                    </div>
                    <div class="span4 bottom-middle-value">
                        <span data-bind="text: BottomMiddleValue"></span>
                        <span><label class="bottom-middle-value-label">Min</label></span>
                    </div>
                    <div class="span4 bottom-right-value">
                        <span data-bind="text: BottomRightValue"></span>
                        <span><label class="bottom-right-value-lable">MWH</label></span>
                    </div>

                </div>
            </div>
        </div>
        <div class="ladle-open" data-bind="classes:{hide: not(LadleOpen)}"></div >
    </div>
    <div  data-bind="classes:{hide: WidgetTypeLadle}">

        <div class="heat-no-widget row-fluid">
            <div class="span3 left-value-no-ladle-widget" >
                <h4 data-bind="text: LeftValue"></h4>
            </div>

            <div class="span9 heat-details box-height-no-ladle-widget">           
                <div class="row-fluid" style="border-bottom: 2px solid #ccc;margin-top: -1.8px;">
                    <div class="span6 no-widget-ton1" style="border-right: 2px solid #ccc">
                        <h6 data-bind="text: TopLeftValue" class="top-left-value"></h6>
                    </div>
                    <div class="span6 no-widget-heat1">
                        <h6 data-bind="text: TopRightValue" class="top-right-value" ></h6>
                   </div>
                </div>
                <div class="row-fluid">
                    <div class="span6 no-widget-ton2" style="border-right: 2px solid #ccc">
                        <h6 data-bind="text: BottomLeftValue2" class="bottom-left-value2"></h6>
                    </div>
                    <div class="span6 no-widget-heat2">
                        <h6 data-bind="text: BottomRightValue2" class="bottom-right-value2"></h6>
                    </div>
                </div>
            </div>
        </div>

    </div>
</script>
