﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" meta:resourcekey="PageResource1" %>

<%@ Import Namespace="System.IO" %>
<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>

<script runat="server">
    String version = WebAppVersion.GetWebAppVersion();

    //@Override this is suggested by Microsoft, overriding the initialize culture function (that is
    //automatically called by the aspx.
    //Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
    //(English).
    protected override void InitializeCulture()
    {
        HttpCookie lang = Request.Cookies["siteLanguage"];

        String selectedLanguage = (lang != null) ? lang.Value : "en";
        UICulture = selectedLanguage;
        Culture = selectedLanguage;

        Thread.CurrentThread.CurrentCulture = CultureInfo.CreateSpecificCulture(selectedLanguage);
        Thread.CurrentThread.CurrentUICulture = new CultureInfo(selectedLanguage);
        base.InitializeCulture();
    }
</script>

<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).

    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<%--view template starts here (will be appended inside a row-fluid)--%>

<script id="lab_heat_report_edit" type="text/x-handlebars-template">
<link href="<%= ResolveUrl("~/app/templates/modal-lab-heat-report-edit/modal-lab-heat-report-edit.css")%>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/assets/libs/js/select2/select2.min.css") %>" rel="stylesheet" />
    <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
        <h4>
            <span style="font-weight: bold;" data-bind="text: Title"></span>
        </h4>
    </div>
    <div class="modal-body">
        <div class="row-fluid firstMainRow">
            <div class="span12">
                <div class="row-fluid">
                    <div id="heatTypeSampleDiv" class="form-group span5">
                        <label for="heatTypeSample">Current Sample:</label>
                        <input disabled type="text" class="form-control" data-bind="value: HeatTypeSample">
                        <%--<span data-bind="text: recurrenceLabel"></span>--%>
                    </div>
                    
                </div>
                <div class="row-fluid">
                     <div class="formbold-input-flex">
                           <div>
                                    <label class="formbold-form-label"> Date </label>
                                    <label class="input-prepend">
                                        <span class="add-on" style="height:38px;line-height:38px;"><i class="icon-calendar"></i></span>
                                        <input 
                                            type="text" 
                                            id="dateFormModal" 
                                            class="input-date-modal"
                                            style="height: 38px;text-align: center;width: 75px; z-index: 5000 !important;"
                                            data-bind="value: sampleDate"
                                            />
                                    </label>   
                                </div>
                                <div>
                                    <label class="formbold-form-label"> Time </label>
                                    <div class="input-group bootstrap-timepicker timepicker">
                                         <label class="input-prepend"> 
                                             <span class="add-on" style="height:38px;line-height:38px;"><i class="icon-time"></i></span>
                                            <input 
                                                id="timeForm" 
                                                type="text" 
                                                class="form-control input-small" 
                                                style=" height: 38px;text-align: center;width: 80px;"
                                                data-bind="value: sampleTime"
                                                
                                                />
                                         </label>                        
                                    </div>
                                </div>

                         </div>
                    
                    
                </div>
                <div class="row-fluid">
                    <div id="typeCodeDiv" class="form-group span6">
                        <label for="typeCode">Sample Location</label>
                        <%--<select class="selectRatedBy" data-bind=" value: ratedById, options: ratedByNames" >  </select>--%>
                       <select 
                            id="TypeCode" 
                            name="TypeCode" 
                            class="formbold-form-select"
                            >
                        </select>
                    </div>
                   <div id="sampleIdDiv" class="form-group span6">
                        <label for="sampleId">Sample ID</label>
                        <%--<select class="selectRatedBy" data-bind=" value: ratedById, options: ratedByNames" >  </select>--%>
                       
                        <input type="text" class="form-control" data-bind="value: SampleIdCode">
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="modal-footer">
        <button id="acceptBtn" class="btn btn-primary">
            <asp:Localize runat='server' meta:resourcekey='accept_btn_label' />
        </button>

        <button id="cancelBtn" class="btn" data-dismiss="modal">
            <asp:Localize runat='server' meta:resourcekey='cancel_btn_label' />
        </button>
    </div>
</script>
