﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" meta:resourcekey="PageResource1" %>

<%@ Import Namespace="System.IO" %>
<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>
<script runat="server">
//@Override this is suggested by Microsoft, overriding the initialize culture function (that is
//automatically called by the aspx.
//Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
//(English).
protected override void InitializeCulture()
{
    HttpCookie lang = Request.Cookies["siteLanguage"];
    
    String selectedLanguage = (lang != null) ? lang.Value : "en";
    UICulture = selectedLanguage ;
    Culture = selectedLanguage ;

    Thread.CurrentThread.CurrentCulture = 
        CultureInfo.CreateSpecificCulture(selectedLanguage);
    Thread.CurrentThread.CurrentUICulture = new 
        CultureInfo(selectedLanguage);
    base.InitializeCulture();
}
</script>
<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).
    
    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<%--view template starts here (will be appended inside a row-fluid)--%>

<link href="<%= ResolveUrl("~/assets/libs/js/jstree/themes/default/style.css") %>" rel="stylesheet" />


<script id="modal_trigger_acceptance_caster_lmf" type="text/x-handlebars-template">            
    <link href="<%= ResolveUrl("~/assets/libs/js/multiselect/virtual-select.min.css") %>" rel="stylesheet" />


    <style type="text/css">
        .vscomp-ele{
            width:193px !important;
        }
        .no-border-radius{
            border-radius: 0px !important;

        }
   
    </style>



    
    <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
        <span style="font-weight:bold;font-size: 22px;" data-bind="text: ModalTitle"> </span> 
    </div>
    <div style="height:350px;padding-bottom:0;padding-top:0;" class="modal-body">
        <div style="min-height:300px;padding-bottom:0;" class="modal-body">      


            <div class="row-fluid" style="margin-left: -2px" data-bind="classes: { hide: pourback, },">
                <div class="span2"></div>
                <div class="span8">                    
                    <span style="font-weight:bold;">                     
                        <asp:Localize runat=server meta:resourcekey=melt_order_label />
                    </span>                 
                    <div id="meltOrders" style="margin-left:10px"></div>
                </div>
            </div>

             
            <div class="row-fluid" style="margin-left: -16px;margin-top:10px;" data-bind="classes: { hide: pourback, },">
                <div class="span2"></div>
                <div class="span8">                    
                    <span style="font-weight:bold;margin-right:10px">                     
                        <asp:Localize runat=server meta:resourcekey=steel_weight_label />
                    </span>                 
                    <input type="text" id="steelWeight" style="width:180px; text-align:left" class="no-border-radius" data-bind="value: SteelWeight," />
                </div>
            </div>

            <div class="row-fluid" style="margin-left: -16px;margin-top:10px;" data-bind="classes: { hide: not(pourback), },">
                <div class="span2"></div>
                <div class="span8">                    
                    <span style="font-weight:bold;margin-right:10px">                     
                        Comments
                    </span>                 
                   <textarea id="PourbackComments" data-bind="value: PourbackComments," style="height: 130px;width: 193px;resize: none;"></textarea>
                </div>
            </div>


    
            <hr style="margin-top:20px"/>

              <div class="row-fluid" data-bind="classes: { hide: not(pourback), },">
                <div class="span2"></div>
                <div class="span8">                    
                    <label style="margin-left:5px;margin-bottom:0 !important; ">
                         <span style="margin:10px; font-weight:bold;margin-right:27px">                     
                            Ladle
                         </span>                 
                        <input type="text" id="Ladle" style="width:180px; text-align:left" class="no-border-radius" data-bind="value: LadleId,"  disabled/>
                    </label>
                </div>
            </div>

            <div class="row-fluid">     
                <div class="span2"></div>           
                <div class="span8">                      
                     <label style="margin-left:5px;margin-bottom:0 !important; ">
                         <span style="margin:10px; font-weight:bold;margin-right:24px">                     
                            <asp:Localize runat=server meta:resourcekey=grade_label />
                         </span>                 
                            <input type="text" id="gradeName" style="width:180px; text-align:left" class="no-border-radius" data-bind="value: GradeName,"  disabled/>
                    </label>
                </div>
            </div>
             <div class="row-fluid">
                <div class="span2"></div>
                <div class="span8">                    
                    <label style="margin-left:5px;margin-bottom:0 !important; ">
                         <span style="margin:10px; font-weight:bold;margin-right:36px">                     
                            <asp:Localize runat=server meta:resourcekey=size_label />
                         </span>                 
                        <input type="text" id="size" style="width:180px; text-align:left" class="no-border-radius" data-bind="value: Size,"  disabled/>
                    </label>
                </div>
            </div>
            

            <hr />



        </div>
    </div>
    <div class="modal-footer">      
        <button id="acceptBtn" class="btn btn-primary pull-left" style="width:200px;height:50px;">
            <asp:Localize runat='server' meta:resourcekey='save_btn_label' />
        </button>
   
        <button id="cancelBtn" class="btn btn-secondary" data-dismiss="modal" style="height:50px">
            <asp:Localize runat='server' meta:resourcekey='cancel_btn_label' />
        </button>
    </div>
</script>
