﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" meta:resourcekey="PageResource1" %>

<%@ Import Namespace="System.IO" %>
<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>
<script runat="server">
//@Override this is suggested by Microsoft, overriding the initialize culture function (that is
//automatically called by the aspx.
//Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
//(English).
protected override void InitializeCulture()
{
    HttpCookie lang = Request.Cookies["siteLanguage"];
    
    String selectedLanguage = (lang != null) ? lang.Value : "en";
    UICulture = selectedLanguage ;
    Culture = selectedLanguage ;

    Thread.CurrentThread.CurrentCulture = 
        CultureInfo.CreateSpecificCulture(selectedLanguage);
    Thread.CurrentThread.CurrentUICulture = new 
        CultureInfo(selectedLanguage);
    base.InitializeCulture();
}
</script>
<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).
    
    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<%--view template starts here (will be appended inside a row-fluid)--%>

<link href="<%= ResolveUrl("~/assets/libs/js/jstree/themes/default/style.css") %>" rel="stylesheet" />


<script id="unk_heat_detection_modal" type="text/x-handlebars-template">            
    <link href="<%= ResolveUrl("~/assets/libs/js/multiselect/virtual-select.min.css") %>" rel="stylesheet" />
    
    <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
        <span style="font-weight:bold;font-size: 22px;" data-bind="text: ModalTitle"> </span> 
    </div>
    <div style="height:200px;padding-bottom:0;padding-top:0;" class="modal-body">
        <div style="max-height:500px;padding-bottom:0;" class="modal-body">      
            <h3 data-bind="text: message"></h3>
        </div>
    </div>
    <div class="modal-footer">
        <div class="row-fluid">
            <div class="span4"></div>
            
            <div class="span4">
                <button id="acceptBtn" class="btn btn-primary pull-left" style="width:200px;height:50px;">
                    <asp:Localize runat='server' meta:resourcekey='save_btn_label' />
                </button>
            </div>
        </div>
    </div>
</script>
