﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" %>

<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>
<script runat="server">
protected override void InitializeCulture()
{

    HttpCookie lang = Request.Cookies["siteLanguage"]; 
    
    String selectedLanguage = (lang != null) ? lang.Value : "en";
    UICulture = selectedLanguage ;
    Culture = selectedLanguage ;

    Thread.CurrentThread.CurrentCulture = 
        CultureInfo.CreateSpecificCulture(selectedLanguage);
    Thread.CurrentThread.CurrentUICulture = new 
        CultureInfo(selectedLanguage);
    base.InitializeCulture();
}
</script>
<%  Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30));%>

<form class="navbar-form pull-right hidden-desktop" onsubmit="return false;" accept-charset="UTF-8">
    <input class="input-large" id="user_username_mobile" type="text" placeholder="Username" />
    <input class="input-large" id="user_password_mobile" type="password" placeholder="Password" />
    <input class="btn btn-primary" style="height: 32px; font-size: 13px;" type="submit" id="signIn_btn_mobile" name="commit" value="<asp:Localize runat="server" meta:resourcekey="submit_button" />">
</form>
<ul class="nav pull-right visible-desktop">
    <%--<li>
        <a href="!/user/signup"><asp:Localize runat="server" meta:resourcekey="sign_up" /></a>
    </li>--%>
    <%--<li class="divider-vertical"></li>--%>
    <div class="dropdown">
    <a style="font-size:18px;padding-top:11px;" id="signIn-drop" class="btn dropdown-toggle" data-toggle="dropdown">
        <span><asp:Localize runat="server" meta:resourcekey="sign_in" /></span>
        <span class="caret"></span>
    </a>
    <div class="dropdown-menu" style="padding: 15px; padding-bottom: 0px;">
        <form id="user_login_form" onsubmit="return false;" accept-charset="UTF-8">
            <div id="user_controlgroup" class="control-group">
                <input id="user_username" style="margin-bottom: 15px;" type="text" name="user[username]" size="30" />
                <input id="user_password" style="margin-bottom: 15px;" type="password" name="user[password]" size="30" />
                <%--<input id="user_remember_me" style="float: left; margin-right: 10px;" type="checkbox" name="user[remember_me]" value="1" />
                <label class="string optional" for="user_remember_me"><asp:Localize runat="server" meta:resourcekey="remember_me" /></label>--%>
                <p id="login_wrong_credentials-help-inline" class="text-error hide"><asp:Localize runat="server" meta:resourcekey="login_wrong_credentials_help_inline" /></p>
            </div>
            <input class="btn btn-primary" style="clear: left; width: 100%; height: 32px; font-size: 13px;" type="submit" id="signIn_btn" name="commit" value="<asp:Localize runat="server" meta:resourcekey="submit_button" />">
        </form>
    </div>
    </div>
</ul>