/*
  backgrid-calendar-cell 1.0.0
*/
(function (root, factory) {

  if (typeof define === 'function' && define.amd) {
    // AMD
    define(["underscore", "backgrid", "moment"], factory);
  } else if (typeof exports === 'object') {
    // CommonJS
    module.exports = factory(require("underscore"), require("backgrid"),
                             require("moment"));
  } else {
    // Browser globals
    factory(root._, root.Backgrid, root.moment);
  }

}(this, function (_, Backgrid, moment) {

    //Fix require config issue with Underscore.
    if (!_)
        _ = this._;

    var padLeft = function (str, pad) {
        str = "" + str;

        return pad.substring(0, pad.length - str.length) + str;
    };

    Backgrid.Extension.DurationFormatter = DurationFormatter = function (options) { };
    DurationFormatter.prototype = new Backgrid.CellFormatter;
    _.extend(DurationFormatter.prototype, {
        //columnName: null,
        displayFormat: 'm:s',
        modelFormat: 's',

        fromRaw: function (rawData) {
            if (rawData == null) return '';
            else return this.parse(rawData, this.modelFormat, this.displayFormat);
        },
        parse: function (value, inputFormat, outputFormat) {
            if (!value) value = 0;

            var dur = moment.duration(value, inputFormat),
                outFormatKeys = ['years', 'y', 'months', 'M', 'weeks', 'w', 'days', 'd', 'hours', 'h', 'minutes', 'm', 'seconds', 's', 'milliseconds', 'ms', ];

            //If output format is not contained on the keys array is because is a complex format like HH:mm.
            //Not a simple format like just seconds or just minutes.
            if (outFormatKeys.indexOf(outputFormat) == -1) {
                switch (outputFormat) {
                    case 's.ms':
                        return outputFormat.replace(/ms/g, padLeft(dur.milliseconds(), '000'))
                                            .replace(/s/g, padLeft(Math.floor(dur.asSeconds()), '00'));
                    case 'm:s':
                        return outputFormat.replace(/s/g, padLeft(dur.seconds(), '00'))
                                            .replace(/m/g, padLeft(Math.floor(dur.asMinutes()), '00'));
                    case 'm:s.ms':
                        return outputFormat.replace(/ms/g, padLeft(dur.milliseconds(), '000'))
                                            .replace(/s/g, padLeft(dur.seconds(), '00'))
                                            .replace(/m/g, padLeft(Math.floor(dur.asMinutes()), '00'));
                    case 'h:m':
                        return outputFormat.replace(/m/g, padLeft(dur.minutes(), '00'))
                                            .replace(/h/g, padLeft(Math.floor(dur.asHours()), '00'));
                    case 'h:m:s':
                        return outputFormat.replace(/s/g, padLeft(dur.seconds(), '00'))
                                            .replace(/m/g, padLeft(dur.minutes(), '00'))
                                            .replace(/h/g, padLeft(Math.floor(dur.asHours()), '00'));
                    case 'h:m:s.ms':
                        return outputFormat.replace(/ms/g, padLeft(dur.milliseconds(), '000'))
                                            .replace(/s/g, padLeft(dur.seconds(), '00'))
                                            .replace(/m/g, padLeft(dur.minutes(), '00'))
                                            .replace(/h/g, padLeft(Math.floor(dur.asHours()), '00'));
                    case 'd h:m:s':
                        return outputFormat.replace(/s/g, padLeft(dur.seconds(), '00'))
                                            .replace(/m/g, padLeft(dur.minutes(), '00'))
                                            .replace(/h/g, padLeft(Math.floor(dur.hours()), '00'))
                                            .replace(/d/g, Math.floor(dur.asDays()) + ' d,');
                }
            }
            else {
                return dur.as(outputFormat);
            }
        },
        //toRaw: function (formattedData, model) {
        //    var date = new moment(formattedData, this.displayFormat).format(this.modelDateFormat),
        //        time = new moment(model.get(this.columnName), this.modelFormat).format(this.modelTimeFormat);

        //    return date + ' ' + time;
        //},
    });
    DurationFormatter.extend = Backbone.Model.extend;
}));
