﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" meta:resourcekey="PageResource1" %>

<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>

<script runat="server">
//@Override this is suggested by Microsoft, overriding the initialize culture function (that is
//automatically called by the aspx.
//Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
//(English).
protected override void InitializeCulture()
{
    HttpCookie lang = Request.Cookies["siteLanguage"]; 
    
    String selectedLanguage = (lang != null) ? lang.Value : "en";
    UICulture = selectedLanguage ;
    Culture = selectedLanguage ;

    Thread.CurrentThread.CurrentCulture = 
        CultureInfo.CreateSpecificCulture(selectedLanguage);
    Thread.CurrentThread.CurrentUICulture = new 
        CultureInfo(selectedLanguage);
    base.InitializeCulture();
}
</script>
<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).
    
    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<%--view template starts here (will be appended inside a row-fluid)--%>


<%  
    StringBuilder timezonesCbxBuilder = new StringBuilder();
    
    var timeZones = TimeZoneInfo.GetSystemTimeZones();

    foreach (TimeZoneInfo timeZone in timeZones)
    {
        timezonesCbxBuilder.Append(
            string.Format(
                "<option value=\"{0}\">{1}</option>",
                timeZone.Id,
                timeZone.DisplayName
            )
        );
    }
 %>



<script id="main_template" type="text/x-handlebars-template">
    <style>
         input[type="checkbox"] {
            margin-top: 0;
        }
    </style>

    <div class="control-group">
        <label class="control-label">
            <%--<asp:localize ID="Localize1" runat="server" meta:resourcekey="status_view_ip_address_label" />--%>
            Date/Time
        </label>
        <div id="datetime_picker" class="controls" style="margin-top:5px;"></div>
    </div>
    <div class="control-group">
        <label class="control-label controls" for="sync_time_ckx">
            <input type="checkbox" id="sync_time_ckx" />
            <%--<asp:localize ID="Localize1" runat="server" meta:resourcekey="status_view_wifi_combo_label" />--%>
            Sinchronize with Internet (if available)
        </label>
    </div>
    <div class="control-group">
        <label class="control-label" for="time_zone_cbx">
            <%--<asp:localize ID="Localize1" runat="server" meta:resourcekey="status_view_wifi_combo_label" />--%>
            Time Zone
        </label>
        <div class="controls">
            <select id="time_zone_cbx" class="input-medium">
                <option>
                    <%--<asp:localize ID="Localize2" runat="server" meta:resourcekey="status_view_wifi_combo_default_opt" />--%>
                </option>
                <%= timezonesCbxBuilder.ToString() %>
                <%--{{#each timeZones}}
                <option value="{{Id}}">{{Name}}</option>
                {{/each}}--%>
            </select>
        </div>
    </div>
</script>