-------------
-- ROLES
-------------
	USE [IHBoxSystem]
	GO
	CREATE ROLE caster1_heats_real_time_read AUTHORIZATION dbo 
	GO  

	USE [IHBoxSystem]
	GO
	EXEC sp_addrolemember 'caster1_heats_real_time_read', 'admin'
	GO

	USE [IHBoxSystem]
	GO
	EXEC sp_addrolemember 'caster1_heats_real_time_read', 'SDI/australtek'
	GO

	USE [IHBoxSystem]
	GO
	CREATE ROLE caster1_heats_real_time_readWrite AUTHORIZATION dbo 
	GO  

	USE [IHBoxSystem]
	GO
	EXEC sp_addrolemember 'caster1_heats_real_time_readWrite', 'admin'
	GO

	USE [IHBoxSystem]
	GO
	EXEC sp_addrolemember 'caster1_heats_real_time_readWrite', 'SDI/australtek'
	GO


	

-------------------
-- Menu and Route
-------------------
	declare @parent int, @result_routeId INT
	select @parent=id from [FrontEnd].[Menu] where [Name] = 'Caster' and Parent is null

	INSERT INTO [FrontEnd].[Routes]
			   ([Route]
			   ,[ModuleName]
			   ,[ModulePath]
			   ,[RequiredRole]
		   )
		 VALUES 
			   (
			   '!/caster-heats-real-time(/)'
			   , 'caster-heats-real-time'
			   , 'custom-screens/caster-heats-real-time/'
			   , 'caster1_heats_real_time_read'           
			   )
			   SET @result_routeId = @@IDENTITY
	INSERT INTO [FrontEnd].[Menu]
			   ([Parent]
			   ,[Name]
			   ,[RouteID]
			   ,[SortOrder]
			   ,[Enabled]
			   ,[Visible]
			   ,[RequiredRole]
			   ,[Group]
			  )
		 VALUES
			   (
			   @parent
			   ,'Caster 1 Heats Real Time'
			   ,@result_routeId 
			   ,1
			   ,1
			   ,0
			   ,'caster1_heats_real_time_read'
			   ,NULL
			 )
	GO


-------------------
-- SP Permissions
-------------------


------------------------------------------
--- SP ---> CAS.GetLastHeatsByProcessId : read/write only
------------------------------------------

EXECUTE sys.sp_addextendedproperty 
@level0type = N'USER' -- The object type
,@level0name = [caster1_heats_real_time_read] -- The role
,@name = N'securedsp-CAS.RTCAS1GetHeats' -- the procedure
,@value = N'' 
GO

EXECUTE sys.sp_addextendedproperty 
@level0type = N'USER' -- The object type
,@level0name = [caster1_heats_real_time_readWrite] -- The role
,@name = N'securedsp-CAS.RTCAS1GetHeats' -- the procedure
,@value = N'' 
GO

--------------------------------------------
----- SP ---> CAS.GetLastHeatsByProcessId : write only
--------------------------------------------

--EXECUTE sys.sp_addextendedproperty 
--@level0type = N'USER' -- The object type
--,@level0name = [caster1_heats_real_time_readWrite] -- The role
--,@name = N'securedsp-CAS.GetLastHeatsByProcessId' -- the procedure
--,@value = N'' 
--GO



--------------------------------------------
----- SP ---> CAS.GetLastHeatsByProcessId: write only
--------------------------------------------

--EXECUTE sys.sp_addextendedproperty 
--@level0type = N'USER' -- The object type
--,@level0name = [caster1_heats_real_time_readWrite] -- The role
--,@name = N'securedsp-CAS.AssignCasterProcessInPLC' -- the procedure
--,@value = N'' 
--GO

--EXECUTE sys.sp_addextendedproperty 
--@level0type = N'USER' -- The object type
--,@level0name = [caster1_heats_real_time_readWrite] -- The role
--,@name = N'securedsp-CAS.UnassignCasterProcessMES' -- the procedure
--,@value = N'' 
--GO


-------------------
--	Profiles
-------------------
	USE [IHBoxSystem]
	GO

	DECLARE @ModuleId INT

	INSERT INTO [SECURITY].[Modules]([Code],[Name])
	VALUES('caster_1_heats_real_time','Caster 1 Heats Real Time')

	SET @ModuleId = @@IDENTITY

	INSERT INTO [SECURITY].[ModuleActions]([ModuleId],[Code],[Name],[Role])
	VALUES(@ModuleId,'readWrite','Read/Write','caster1_heats_real_time_readWrite')


	INSERT INTO [SECURITY].ModuleActions(ModuleId,Code,[Name],[Role])
	VALUES (@ModuleId,'read','Read','caster1_heats_real_time_read')


GO


