<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" meta:resourcekey="PageResource1" %>

<%@ Import Namespace="System.IO" %>
<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>

<script runat="server">
    String version = WebAppVersion.GetWebAppVersion();

    //@Override this is suggested by Microsoft, overriding the initialize culture function (that is
    //automatically called by the aspx.
    //Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
    //(English).
    protected override void InitializeCulture()
    {
        HttpCookie lang = Request.Cookies["siteLanguage"];

        String selectedLanguage = (lang != null) ? lang.Value : "en";
        UICulture = selectedLanguage;
        Culture = selectedLanguage;

        Thread.CurrentThread.CurrentCulture = CultureInfo.CreateSpecificCulture(selectedLanguage);
        Thread.CurrentThread.CurrentUICulture = new CultureInfo(selectedLanguage);
        base.InitializeCulture();
    }
</script>

<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).

    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<%--view template starts here (will be appended inside a row-fluid)--%>

<link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/lib/backgrid.css")%>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/extensions/valid-limit-cell/backgrid-valid-limit-cell.css") %>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/app/custom-screens/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + "/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + ".css")%>" rel="stylesheet" />
<%--<link href="<%= ResolveUrl("~/app/custom-screens/melt-shop-overview/melt-shop-overview.css")%>" rel="stylesheet" />--%>
<link href="<%= ResolveUrl("~/assets/libs/js/jquery.contextMenu/jquery.contextMenu.css") %>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/assets/libs/js/autocomplete/backbone.autocomplete.css") %>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/assets/libs/js/multiselect/virtual-select.min.css") %>" rel="stylesheet" />


<div class="screen-content">

    <div class="top-screen row-fluid division-border-height-size-big" >        
        <div class="span3 division-border division-border-height-size-big row-fluid">
            <div class="span6">
                <div>                    
                    <table>
                        <tbody>                        
                            <tr><td><label class="label-hot-charge-cooling-bed">HOT CHARGE</label> </td></tr>   
                            <tr><td class="cooling-bed-hot-charge-position"><div class="drop-hot-charge-container" id="hot-charge"></div></td></tr>                       
                        </tbody>
                   </table>
                </div>
            </div>
            <div class="span6">                 
                <table>
                    <tbody>
                        <tr><td><label class="control-label label-hot-charge-cooling-bed">COOLING BED</label> </td></tr>
                        
                        <tr>
                            <td class="cooling-bed-hot-charge-position">
                            <div class="drop-cooling-bed-container" id="cooling-bed"> <%-- for drag/drop add class= 'dropable '  --%>
                            </div>
                            </td>
                        </tr>
                                
                       
                    </tbody>
                </table>
            </div>
        </div>
        <div class="span9 row-fluid">               

            <div class="span8 division-border division-border-height-size-big">
                
                <div class="row-fluid" style="margin-bottom:10px;">  
                    <div class="span1"></div>
                    <div class="span2">                
                        <button id="TWIBtn" class="btn action-buttons" style="width:100%;height:50%" data-bind="disabled:  readOnlyPermissions">TWI</button>
                    </div>
                    <div class="span3">                
                        <button id="LadleOpenBtn" class="btn action-buttons" style="width:100%;height:50%" data-bind="disabled:  readOnlyPermissions">Manual Ladle Open</button>
                    </div>
                    <div class="span3">
                        <button id="CoversReportBtn" class="btn action-buttons" style="width:100%;height:50%" data-bind="disabled:  readOnlyPermissions">Covers Report</button>
                    </div>
                    <div class="span3">
                        <button id="ReassignProductBtn" class="btn action-buttons" style="width:100%;height:50%" data-bind="classes:{hide: not(reassignPermissions)}">Reassign Products</button>
                    </div>
                </div>

                <div class="processes-grid-container"></div> 
                <table id="runout">
                    <tr>
                        <td rowspan="4" id="turret-tundish">
                            <div class="row-fluid">
                                <div class="span4">                                     
                                    <div style="width: 100%; height: 150px">
                                        <div class="heat ">                                            
                                            <h4 data-bind="text: Title_3" class="title"></h4>
                                            <div class="row-fluid"> 
                                                <div class="span2 left-value" id="in-transit-position">
                                                    <h3 data-bind="text: LeftValue_3"></h3>
                                                </div>
                                                <div class="span10 heat-details box-height-ladle-widget">
                                                    <h4 data-bind="text: TopValue_3" class="top-value intransit-heat"></h4>
                                                    <h6 data-bind="text: MiddleValue_3"  class="middle-value"></h6>
            
                                                    <div class="row-fluid border-top-bottom">
                                                        <div class="span4 border-right" >
                                                            <h6 data-bind="text: MiddleLeftValue_3" class="middle-left-value"></h6>
            
                                                        </div>
                                                        <div class="span8">
                                                                <h6 data-bind="text: MiddleRightValue_3" class="middle-right-value" ></h6>
            
                                                        </div>
                                                    </div>

                                                    <div class="row-fluid">
                                                        <div class="span4 bottom-left-value">
                                                            <span data-bind="text: BottomLeftValue_3" class="label-heats-min-mwh"></span>
                                                            <span><label class="bottom-left-value-label">Heats</label></span>

                                                        </div>
                                                        <div class="span4 bottom-middle-value">
                                                            <span data-bind="text: BottomMiddleValue_3" class="label-heats-min-mwh"></span>
                                                            <span><label class="bottom-middle-value-label">Min</label></span>
                                                        </div>
                                                        <div class="span4 bottom-right-value">
                                                            <span data-bind="text: BottomRightValue_3" class="label-heats-min-mwh"></span>
                                                            <span><label class="bottom-right-value-lable">MWH</label></span>
                                                        </div>

                                                    </div>

                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>                                
                                <div class="span4">
                                    <div style="width: 100%; height: 150px;">
                                        <div class="heat">
                                            <h4 data-bind="text: Title_2" class="title"></h4>
                                            <div class="row-fluid"> 
                                                <div class="span2 left-value" id="out-position">
                                                    <h3 data-bind="text: LeftValue_2"></h3>
                                                </div>
                                                <div class="span10 heat-details box-height-ladle-widget">
                                                    <h4 data-bind="text: TopValue_2" class="top-value outboard-heat"></h4>
                                                    <h6 data-bind="text: MiddleValue_2"  class="middle-value"></h6>
            
                                                    <div class="row-fluid border-top-bottom">
                                                        <div class="span4 border-right" >
                                                            <h6 data-bind="text: MiddleLeftValue_2" class="middle-left-value"></h6>
            
                                                        </div>
                                                        <div class="span8">
                                                                <h6 data-bind="text: MiddleRightValue_2" class="middle-right-value" ></h6>
            
                                                        </div>
                                                    </div>

                                                    <div class="row-fluid">
                                                        <div class="span4 bottom-left-value">
                                                            <span data-bind="text: BottomLeftValue_2" class="label-heats-min-mwh"></span>
                                                            <span><label class="bottom-left-value-label">Heats</label></span>

                                                        </div>
                                                        <div class="span4 bottom-middle-value">
                                                            <span data-bind="text: BottomMiddleValue_2" class="label-heats-min-mwh"></span>
                                                            <span><label class="bottom-middle-value-label">Min</label></span>
                                                        </div>
                                                        <div class="span4 bottom-right-value">
                                                            <span data-bind="text: BottomRightValue_2" class="label-heats-min-mwh"></span>
                                                            <span><label class="bottom-right-value-lable">MWH</label></span>
                                                        </div>

                                                    </div>

                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>                                
                                <div class="span4">
                                    <div style="width: 100%; height: 150px;">                                         
                                        <div class="heat">
                                            <h4 data-bind="text: Title_1" class="title"></h4>
                                            <div class="row-fluid"> 
                                                <div class="span2 left-value" id="in-position">
                                                <h3 data-bind="text: LeftValue_1"></h3>
                                            </div>
                                                <div class="span10 heat-details box-height-ladle-widget">
                                                <h4 data-bind="text: TopValue_1" class="top-value inboard-heat"></h4>
                                                <h6 data-bind="text: MiddleValue_1"  class="middle-value"></h6>
            
                                                <div class="row-fluid border-top-bottom">
                                                    <div class="span4 border-right" >
                                                        <h6 data-bind="text: MiddleLeftValue_1" class="middle-left-value"></h6>
            
                                                    </div>
                                                    <div class="span8">
                                                            <h6 data-bind="text: MiddleRightValue_1" class="middle-right-value" ></h6>
            
                                                    </div>
                                                </div>

                                                <div class="row-fluid">
                                                    <div class="span4 bottom-left-value">
                                                        <span data-bind="text: BottomLeftValue_1" class="label-heats-min-mwh"></span>
                                                        <span><label class="bottom-left-value-label">Heats</label></span>

                                                    </div>
                                                    <div class="span4 bottom-middle-value">
                                                        <span data-bind="text: BottomMiddleValue_1" class="label-heats-min-mwh"></span>
                                                        <span><label class="bottom-middle-value-label">Min</label></span>
                                                    </div>
                                                    <div class="span4 bottom-right-value">
                                                        <span data-bind="text: BottomRightValue_1" class="label-heats-min-mwh"></span>
                                                        <span><label class="bottom-right-value-lable">MWH</label></span>
                                                    </div>

                                                </div>
                                            </div>
                                            </div>
                                        </div>
                                        <div class="ladle-open" data-bind="classes:{hide: not(LadleOpen)}"></div >
                                        <div class="ladle-open-not-open" data-bind="classes:{hide: LadleOpen}"></div >                                         
                                    </div>
                                </div>
                            </div>
                            <div class="row-fluid">
                                <div class="span4"></div>
                                <div class="span4">
                                    <div class="row-fuild">
                                        <div class="span1"></div>
                                        <div class="span9" style="float:right">
                                            <label style="margin-bottom: -4% !important;font-weight: bold; " class="control-label">
                                                <asp:Localize runat="server" meta:resourcekey="tundish_car_1_label" /> 
                                                    <select disabled data-bind=" value: tundish1Number, options: tundishes, optionsDefault: { label: '<asp:Localize runat=server meta:resourcekey=no_tundish_selected />', value: '-' }" style="width:105px;margin-top:5px;margin-left:20px">
                                                    </select>
                                            </label>
                                        </div>
                                        <div class="span2">
                                            <div class="tunidsh1Circle"></div>
                                        </div>                                        
                                    </div>
                                    <div class="row-fluid">                                        
                                        <div class="span1"></div>
                                        <div class="span9" style="float:right">
                                            <label style="margin-bottom:0 !important;font-weight: bold; " class="control-label">
                                                <asp:Localize runat="server" meta:resourcekey="tundish_car_2_label" /> 
                                                    <select disabled data-bind=" value: tundish2Number, options: tundishes, optionsDefault: { label: '<asp:Localize runat=server meta:resourcekey=no_tundish_selected />', value: '-' }" style="width:105px;margin-top:5px;margin-left:20px">
                                                    </select>
                                            </label>
                                        </div>
                                        <div class="span2">                                            
                                            <div class="tunidsh2Circle"></div>
                                        </div>
                                    </div>
                                </div>
                                <div class="span4">   
                                    <div style="width: 100%; height: 60px;margin-top:20px;"> 
                                            <div class="heat-no-widget row-fluid">                                            
                                            <div data-bind="classes:{hide: SingleLeftValue}">
                                                <div class="span8 heat-details box-height-no-ladle-widget" style="border-left: none">   
                                         
                                                    <div class="row-fluid" style="border-bottom: 2px solid #ccc;margin-top: -1.8px;">
                                                        <div class="span6 no-widget-ton1 tundish-heat-top" style="border-right: 2px solid #ccc" >
                                                            <h5 data-bind="text: TopLeftValue_4" class="top-left-value" style="margin-top: 3px;"></h5>
                                                        </div>
                                                        <div class="span6 no-widget-heat1">
                                                            <div class="row-fluid">
                                                                <div class="span9">                                         
                                                                    <h5 data-bind="text: TopRightValue_4" class="top-right-value" style="margin-top: 3px;"></h5>
                                                                </div>
                                                                <div class="span3" style="margin-left: -4px;">                                                            
                                                                    <span><label class="tundish-unit-labels">tons</label></span>
                                                                </div>
                                                            </div>

                                                        </div>
                                                    </div>
                                                    <div class="row-fluid">
                                                        <div class="span6 no-widget-ton2 tundish-heat-bottom-2" style="border-right: 2px solid #ccc">
                                                            <h5 data-bind="text: BottomLeftValue2_4" class="bottom-left-value2" style="margin-top: 3px;"></h5>
                                                        </div>
                                                        <div class="span6 no-widget-heat2">

                                                                <div class="row-fluid">
                                                                <div class="span9">                                         
                                                                    <h5 data-bind="text: BottomRightValue2_4" class="bottom-right-value2" style="margin-top: 3px;"></h5>
                                                                </div>
                                                                <div class="span3" style="margin-left: -4px;">                                                            
                                                                    <span><label class="tundish-unit-labels">tons</label></span>
                                                                </div>
                                                            </div>

                                                        </div>
                                                    </div>
                                                </div>
                                                    <div class="span4 single-value-middle left-value-no-ladle-widget" style="margin-left:-2px;">
                                                        <div class="row-fluid">
                                                            <div class="span9">                                                             
                                                            <h5 data-bind="text: LeftValue_4"></h5>
                                                            </div>
                                                            <div class="span3" style="margin-top: 5px;">                                                             
                                                            <span><label class="tundish-unit-labels">F</label></span>
                                                            </div>
                                                        </div>
                                                </div>
                                            </div>


                                                <div data-bind="classes:{hide: not(SingleLeftValue)}" >
                                                <div class="span4 left-value-no-ladle-widget tundish-heat-bottom" style="margin-right:-8px;">                                                 
                                                    <h5 data-bind="text: BottomLeftValue2_4"></h5>                                              
                                                </div>
                                                <div class="span4 left-value-no-ladle-widget single-value-middle">    
                                                    <div class="row-fluid">
                                                        <div class="span9">                                                            
                                                            <h5 data-bind="text: BottomRightValue2_4"></h5> 
                                                        </div>
                                                        <div class="span3" style="margin-top: 5px;">                                                            
                                                            <span><label class="tundish-unit-labels">tons</label></span>
                                                        </div>
                                                    </div>
                                                </div>
                                                    <div class="span4 single-value-middle left-value-no-ladle-widget" >
                                                        <div class="row-fluid">
                                                            <div class="span9">                                                             
                                                            <h5 data-bind="text: LeftValue_4"></h5>
                                                            </div>
                                                            <div class="span3" style="margin-top: 5px;">                                                             
                                                            <span><label class="tundish-unit-labels">F</label></span>
                                                            </div>
                                                        </div>
                                                     
                                                </div>
                                                </div>

                                          
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </td>
                    </tr>                    
                </table>
            </div>
            <div class="span4 division-border division-border-height-size-big">
                <div class="row-fluid">
                    <div class="span6">
                           <input type="text" style="width:90px;float: left;margin-right: 10px;" id="search" data-bind="value: search," placeholder="<asp:Localize runat=server meta:resourcekey=search_place_holder />"/>           
                           <select style="width:100px;" id="strands" data-bind="value: strandId, options: strands, optionsDefault: { label: '<asp:localize runat=server meta:resourcekey=strand_combo_all_opt />', value: '-' },disabled:  disabledStrandPicker "></select> 
                    </div>
                    
                    <div class="span3">
                        <button id="addNewPiece" class="btn btn-success pull-right" style="width:80px;height:50%"  data-bind="classes: { hide: disabledAddPiece, }" >Add</button> 
                  
                    </div>
                    <div class="span3">
                        <button id="backToRealTime" class="btn btn-primary pull-right" style="width:100px;height:50%" data-bind="disabled:  realTime ">Go RT</button>
                     
                    </div>
                   
                </div>    
                <div class="products-grid-container" id="main-div" data-bind="classes: { hide: isLoading_products, }" ></div>
                <div class="no-data-poster row-fluid text-center animated fadeIn not-print" data-bind="classes: { hide: not(isLoading_products), }" style="height:500px;">
                    <div class="row-fluid" style="position:relative;top:100px;">
                        <i class="fa fa-cog fw-icon-4x fa-spin" style="font-size:115px;"></i>
                    </div>
                    <div class="row-fluid" style="position:relative;top:115px;">
                        <h3 style="font-size:50px;">
                            <asp:localize runat="server" meta:resourcekey="loading_data" />
                        </h3>
                    </div>
                </div>


            </div>
        </div>
    </div>
    <div class="bottom-screen row-fluid division-border-height-size-small">
        <div class="span4 division-border division-border-height-size-small">
            <table style="line-height:0px !important">
                  <tr class="drop-container-runout-row-l-no-border">
                    <td class="pos6-empty-cell"></td>
                    <td class="drop-container-runout"><div class="dropable drop-positon-container" id="pos11"></div></td>
                    <td class="no-border-runout-table"></td>
                    <td class="no-border-runout-table"></td>
                    <td class="no-border-runout-table"></td>
                </tr>
                  <tr class="drop-container-runout-row-l-no-border">
                    <td class="pos6-empty-cell"></td>
                    <td class="drop-container-runout"><div class="dropable drop-positon-container" id="pos10"></div></td>
                    <td class="no-border-runout-table"></td>
                    <td class="no-border-runout-table"></td>
                    <td class="no-border-runout-table"></td>
                </tr>
                  <tr class="drop-container-runout-row-l-no-border">
                    <td class="pos6-empty-cell"></td>
                    <td class="drop-container-runout"><div class="dropable drop-positon-container" id="pos9"></div></td>
                    <td class="no-border-runout-table"></td>
                    <td class="no-border-runout-table"></td>
                    <td class="no-border-runout-table"></td>
                </tr>
                  <tr class="drop-container-runout-row-l-no-border">
                    <td class="pos6-empty-cell"></td>
                    <td class="drop-container-runout"><div class="dropable drop-positon-container" id="pos8"></div></td>
                    <td class="no-border-runout-table"></td>
                    <td class="no-border-runout-table"></td>
                    <td class="no-border-runout-table"></td>
                </tr>
                <tr class="drop-container-runout-row-l">
                     <td class="pos6-svg-container">
                        <svg class="pos6-svg hide" id="s1-rectsvg">
                            <rect x="3" y="20" width="12" height="12" stroke="black" fill="red"></rect>
                        </svg>
                    </td>
                    <td class="drop-container-runout"><div class="dropable drop-positon-container" id="strand1pos6"></div></td>
                    <td class="drop-container-runout"><div class="dropable drop-positon-container" id="strand1pos4"></div></td>
                    <td class="drop-container-runout"><div class="dropable drop-positon-container" id="strand1pos3"></div></td>
                    <td class="drop-container-runout"><div class="dropable drop-positon-container" id="strand1pos2"></div></td>
                </tr>
                
                <tr class="drop-container-runout-row-l">
                    <td class="pos6-svg-container">
                        <svg class="pos6-svg hide" id="s2-rectsvg">
                            <rect x="3" y="20" width="12" height="12" stroke="black" fill="red"></rect>
                        </svg>
                    </td>
                    <td class="drop-container-runout"><div class="dropable drop-positon-container" id="strand2pos6"></div></td>
                    <td class="drop-container-runout"><div class="dropable drop-positon-container" id="strand2pos4"></div></td>
                    <td class="drop-container-runout"><div class="dropable drop-positon-container" id="strand2pos3"></div></td>
                    <td class="drop-container-runout"><div class="dropable drop-positon-container" id="strand2pos2"></div></td>
                </tr>
                
                <tr class="drop-container-runout-row-l">
                    <td class="pos6-svg-container">
                        <svg class="pos6-svg hide" id="s3-rectsvg">
                            <rect x="3" y="20" width="12" height="12" stroke="black" fill="red"></rect>
                        </svg>
                    </td>
                    <td class="drop-container-runout"><div class="dropable drop-positon-container" id="strand3pos6"></div></td>
                    <td class="drop-container-runout"><div class="dropable drop-positon-container" id="strand3pos4"></div></td>
                    <td class="drop-container-runout"><div class="dropable drop-positon-container" id="strand3pos3"></div></td>
                    <td class="drop-container-runout"><div class="dropable drop-positon-container" id="strand3pos2"></div></td>
                </tr>
                
                <tr class="drop-container-runout-row-l">
                    <td class="pos6-svg-container">
                        <svg class="pos6-svg hide" id="s4-rectsvg">
                            <rect x="3" y="20" width="12" height="12" stroke="black" fill="red"></rect>
                        </svg>
                    </td>
                    <td class="drop-container-runout"><div class="dropable drop-positon-container" id="strand4pos6"></div></td>
                    <td class="drop-container-runout"><div class="dropable drop-positon-container" id="strand4pos4"></div></td>
                    <td class="drop-container-runout"><div class="dropable drop-positon-container" id="strand4pos3"></div></td>
                    <td class="drop-container-runout"><div class="dropable drop-positon-container" id="strand4pos2"></div></td>
                </tr>
            </table>
        </div>
        <div class="span8 row-fluid division-border division-border-height-size-small">
             <table id="positions" style="line-height:0px !important">
                 
                      <tr class="info-table-no-border"></tr>
                      <tr class="info-table-no-border"></tr>
                      <tr class="info-table-no-border"></tr>                 
                     <tr class="info-table-no-border"> 
                        <th style="width:56% !important;text-align:left"><label style="margin-left:40%;font-weight: bold" class="control-label">Home</label></th>
                        <th class="real-time-bars-table-header-sm"><label class="control-label label-real-time-table">Speed in/min</label></th>
                        <th class="real-time-bars-table-header-sm"><label class="control-label label-real-time-table">Preset in</label></th>
                        <th class="real-time-bars-table-header-sm"><label class="control-label label-real-time-table">Measured in</label></th>
                        <th class="real-time-bars-table-header-l" ><label class="control-label label-real-time-table">Remaining</label></th>
                        <th style="width:6% !important"></th>
                     </tr>
                      <tr>
                        <td><svg height="50px" id="strand1bars" style="width:100% !important"></svg></td>  
                        <td class="cell-real-time-table"><label class="control-label" style="font-weight: bold;text-align: center" data-bind="text:Speed_S1" ></label></td>
                        <td class="cell-real-time-table"><label class="control-label" style="font-weight: bold;text-align: center" data-bind="text:SP_S1" ></label></td>
                        <td class="cell-real-time-table"><label class="control-label" style="font-weight: bold;text-align: center" data-bind="text:Measured_S1" ></label></td>
                        <td class="cell-real-time-table" style="height:48px !important">
                            <label class="control-label real-time-bars-table-remaining-values" data-bind="text:MaterialRemaining_Top_S1" ></label>
                            <label class="control-label real-time-bars-table-remaining-values" data-bind="text:MaterialRemaining_Middle_S1" ></label>
                            <label class="control-label real-time-bars-table-remaining-values" data-bind="text:MaterialRemaining_Bottom_S1" ></label>
                        </td>                    
                        <td style="border: 2px solid #ccc;background-color: #eee;" id="Name_S1"><label class="control-label" style="font-weight: bold;text-align: center;" data-bind="text:Name_S1" ></label></td>

                      </tr>
                     <tr>
                        <td><svg height="50px" id="strand2bars"  style="width:100% !important"></svg></td>   
                         <td class="cell-real-time-table"><label class="control-label"  style="font-weight: bold;text-align: center" data-bind="text:Speed_S2" ></label></td>
                         <td class="cell-real-time-table"><label class="control-label" style="font-weight: bold;text-align: center" data-bind="text:SP_S2" ></label></td>
                         <td class="cell-real-time-table"><label class="control-label" style="font-weight: bold;text-align: center" data-bind="text:Measured_S2" ></label></td>
                         <td class="cell-real-time-table" style="height:48px !important">                             
                             <label class="control-label real-time-bars-table-remaining-values" data-bind="text:MaterialRemaining_Top_S2" ></label>
                             <label class="control-label real-time-bars-table-remaining-values" data-bind="text:MaterialRemaining_Middle_S2" ></label>
                             <label class="control-label real-time-bars-table-remaining-values" data-bind="text:MaterialRemaining_Bottom_S2" ></label>
                         </td>
                         <td style="border: 2px solid #ccc;background-color: #eee;" id="Name_S2"><label class="control-label" style="font-weight: bold;text-align: center;" data-bind="text:Name_S2" ></label></td>
                     </tr>
                     <tr>
                        <td><svg height="50px" id="strand3bars" style="width:100% !important"></svg></td>   
                        <td class="cell-real-time-table"><label class="control-label"  style="font-weight: bold;text-align: center" data-bind="text:Speed_S3" ></label></td>
                        <td class="cell-real-time-table"><label class="control-label" style="font-weight: bold;text-align: center" data-bind="text:SP_S3" ></label></td>
                        <td class="cell-real-time-table"><label class="control-label" style="font-weight: bold;text-align: center" data-bind="text:Measured_S3" ></label></td>
                        <td class="cell-real-time-table" style="height:48px !important">
                             <label class="control-label real-time-bars-table-remaining-values" data-bind="text:MaterialRemaining_Top_S3" ></label>
                             <label class="control-label real-time-bars-table-remaining-values" data-bind="text:MaterialRemaining_Middle_S3" ></label>
                             <label class="control-label real-time-bars-table-remaining-values" data-bind="text:MaterialRemaining_Bottom_S3" ></label>
                        </td>                         
                         <td style="border: 2px solid #ccc;background-color: #eee;" id="Name_S3"><label class="control-label" style="font-weight: bold;text-align: center;" data-bind="text:Name_S3" ></label></td>
                      </tr>
                     <tr>
                        <td><svg height="50px" id="strand4bars"  style="width:100% !important"></svg></td>  
                         <td class="cell-real-time-table"><label class="control-label" style="font-weight: bold;text-align: center" data-bind="text:Speed_S4" ></label></td>
                         <td class="cell-real-time-table"><label class="control-label" style="font-weight: bold;text-align: center" data-bind="text:SP_S4" ></label></td>
                         <td class="cell-real-time-table"><label class="control-label" style="font-weight: bold;text-align: center" data-bind="text:Measured_S4" ></label></td>
                         <td class="cell-real-time-table" style="height:48px !important">
                             <label class="control-label real-time-bars-table-remaining-values" data-bind="text:MaterialRemaining_Top_S4" ></label>
                             <label class="control-label real-time-bars-table-remaining-values" data-bind="text:MaterialRemaining_Middle_S4" ></label>
                             <label class="control-label real-time-bars-table-remaining-values" data-bind="text:MaterialRemaining_Bottom_S4" ></label>
                         </td>
                         <td style="border: 2px solid #ccc;background-color: #eee;" id="Name_S4"><label class="control-label" style="font-weight: bold;text-align: center;" data-bind="text:Name_S4" ></label></td>
            
                      </tr>
                 </table>

                <div class="hide" data-bind="collection: $productsTablePosition, itemView: 'productsPositionView'"></div>
        </div>
    </div>
</div>





<script id="actions_cell_template" type="text/x-handlebars-template">
    <div class="text-center">
         <button data-toggle="tooltip" data-placement="bottom" data-cell-action="EDIT_DETAILS" title="<asp:Localize runat=server meta:resourcekey=edit_details_title />" class="btn btn-cell-action btn-small btn-edit-details"><i class="fa fa-pencil"></i></button>
    </div>
</script>
<script id="assign_heats_torch_modal" type="text/x-handlebars-template">
    <div class="modal-header" >    
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
        <h4>
            <span data-bind="text: title" style="font-weight:bold;"></span>
        </h4>    
    </div>
    <div class="modal-body">
        <div style="padding-bottom:0;" class="modal-body">
            <div class="row-fluid">                 
                
                <div class="pull-left" style="width:100%;margin-left:0;">  
                        <div class="no-data-poster row-fluid text-center animated fadeIn" data-bind="classes: { hide: any(hasData, isLoading), }" style="height:350px;">
                            <div class="row-fluid" style="position:relative;top:100px;">
                                <i class="fw-icon-circle-blank fw-icon-4x" style="font-size:115px;"></i>
                            </div>
                            <div class="row-fluid" style="position:relative;top:115px;">
                                <h3 style="font-size:50px;">
                                    <asp:localize runat="server" meta:resourcekey="no_data_available" />
                                </h3>
                            </div>
                        </div>
                        <div class="no-data-poster row-fluid text-center animated fadeIn" data-bind="classes: { hide: not(isLoading), }" style="height:350px;">
                            <div class="row-fluid" style="position:relative;top:100px;">
                                <i class="fa fa-cog fw-icon-4x fa-spin" style="font-size:115px;"></i>
                            </div>
                            <div class="row-fluid" style="position:relative;top:115px;">
                                <h3 style="font-size:50px;">
                                    <asp:localize runat="server" meta:resourcekey="loading_data" />
                                </h3>
                            </div>
                        </div>
                </div>
               
                <div class="last-heats-grid-container row-fluid infinite-container" data-bind="classes: { hide: any(not(hasData), isLoading), }"></div>   

            </div>
        </div>
    </div>
    <div class="modal-footer">
        <div class="modal-status-msg-container pull-left">
            <div class="modal-status-msg hide" data-bind="toggle: notEquals(errorMsg, ''),">
                <span data-bind="text: errorMsg, attr: { title: errorMsg, }," style="color:#ff0000;font-size:16px;"></span>
            </div>
            <div class="modal-status-msg hide" data-bind="toggle: processing,">
                <asp:Localize runat='server' meta:resourcekey='processing_msg' />
                <i class="fa fa-cog fa-spin"></i>
            </div>
        </div>
        <button  id="unassignBtn" class="btn btn-primary btn-danger" data-bind="enabled: not(processing), classes: { hide: not(show_unassign_btn), }">
            <asp:Localize runat='server' meta:resourcekey='unassign_btn_label' />
        </button>
        <button id="acceptBtn" class="btn btn-primary" data-bind="enabled: all(not(processing), selectedHeatId),">
            <asp:Localize runat='server' meta:resourcekey='accept_btn_label' />
        </button>
        
        <button id="cancelBtn" class="btn" data-dismiss="modal" data-bind="enabled: not(processing),">
            <asp:Localize runat='server' meta:resourcekey='cancel_btn_label' />
        </button>


    </div>
</script>
<script id="split_product_template" type="text/x-handlebars-template">
    <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
        <h3><asp:Localize runat='server' meta:resourcekey='split_product_modal_title' /></h3>        
    </div>
    <div style="max-height:350px;padding-bottom:0;padding-top:0;" class="modal-body">
        <div style="max-height:300px;padding-bottom:0;" class="modal-body">
            <div class="row-fluid" style="text-align:left;">
                <div style="margin-top:5px; padding-top:5px; text-align:right;" class="span4 control-group form-inline">
                    <asp:Localize runat=server meta:resourcekey=product_label />
                </div>
                <div style="margin-left:10px; margin-top: 5px; float:left;" class="control-group form-inline">
                    <input type="text" style="width:186px;"data-bind="value: productNumber" disabled>
                </div>
            </div>
            <div class="row-fluid" style="text-align:left;">
                <div style="margin-top:5px; padding-top:5px; text-align:right;" class="span4 control-group form-inline">
                    <asp:Localize runat=server meta:resourcekey=piece_length_label />
                </div>
                <div style="margin-left:10px; margin-top: 5px; float:left;" class="control-group form-inline">
                    <input type="number" style="width:186px;" data-bind="value: pieceLength" />
                </div>
            </div>
            <div class="row-fluid" style="text-align:left;">
                <div style="margin-top:5px; padding-top:5px; text-align:right;" class="span4 control-group form-inline">
                    <asp:Localize runat=server meta:resourcekey=scrap_length_label />
                </div>
                <div style="margin-left:10px; margin-top: 5px; float:left;" class="control-group form-inline">
                    <input type="number" style="width:186px;" data-bind="value: scrapLength" />
                </div>
            </div>
        </div>
      
    </div>
    <div class="modal-footer">
           <button id="acceptBtn" class="btn btn-primary" >
            <asp:Localize runat='server' meta:resourcekey='accept_btn_label' />
        </button>
        
        <button id="cancelBtn" class="btn" data-dismiss="modal">
            <asp:Localize runat='server' meta:resourcekey='cancel_btn_label' />
        </button>

    </div>
</script>
<script id="add_new_product_template" type="text/x-handlebars-template">
  <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
        <h3><asp:Localize runat='server' meta:resourcekey='add_new_product_modal_title' /></h3>        
    </div>
    <div style="max-height:350px;padding-bottom:0;padding-top:0;" class="modal-body">
        <div style="max-height:300px;padding-bottom:0;" class="modal-body">
            <div class="row-fluid" style="text-align:left;">
                <div style="margin-top:5px; padding-top:5px; text-align:right;" class="span4 control-group form-inline">
                    <asp:Localize runat=server meta:resourcekey=heat_name_label />
                </div>
                <div style="margin-left:10px; margin-top: 5px; float:left;" class="control-group form-inline">
                    <input type="text" style="width:186px;"data-bind="value: heatNumber" disabled>
                </div>
            </div>
             <div class="row-fluid" style="text-align:left;">
                 <div style="margin-top:5px; padding-top:5px; text-align:right;" class="span4 control-group form-inline">
                    <asp:Localize runat=server meta:resourcekey=strand_combo_label />
                </div>
                <div style="margin-left:10px; margin-top: 5px; float:left;" class="control-group form-inline">      
                    <select style="width:120px;" data-bind="value: strandId, options: strands"></select> 
                </div>
                 <div style="margin-left:10px; margin-top: 5px; float:left;" class="control-group form-inline">      
                    <select style="width:70px;" data-bind="value: sequenceId, options: sequences"></select> 
                </div>

              </div>
            <div class="row-fluid" style="text-align:left;">
                 <div style="margin-top:5px; padding-top:5px; text-align:right;" class="span4 control-group form-inline">
                    Mold
                </div>
                 <div style="margin-left:10px; margin-top: 5px; float:left;" class="control-group form-inline">      
                    <select style="width:200px;" data-bind="value: moldId, options: molds"></select> 
                </div>

              </div>
            <div class="row-fluid" style="text-align:left;">
                <div style="margin-top:5px; padding-top:5px; text-align:right;" class="span4 control-group form-inline">
                    <asp:Localize runat=server meta:resourcekey=piece_length_label />
                </div>
                <div style="margin-left:10px; margin-top: 5px; float:left;" class="control-group form-inline">
                    <input type="text" style="width:186px;" data-bind="value: pieceLength" />
                </div>
            </div>
           
        </div>
      
    </div>
    <div class="modal-footer">

           <button id="acceptBtn" class="btn btn-primary" >
            <asp:Localize runat='server' meta:resourcekey='accept_btn_label' />
        </button>
        
        <button id="cancelBtn" class="btn" data-dismiss="modal">
            <asp:Localize runat='server' meta:resourcekey='cancel_btn_label' />
        </button>

    </div>
</script>
<script id="edit_length_modal" type="text/x-handlebars-template">
  <div class="modal-header">
    <h5>Edit Length</h5>
    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
  </div>

  <div class="modal-body">
    <div class="form-grid">

      <!-- Product Number -->
      <label class="form-label">Product Number</label>
      <input class="field-input form-control" type="text"
             data-bind="value: productNumber" style="text-align:center;" disabled>

      <!-- Toggle -->
      <label class="form-label">Length Type</label>
      <div>
        <div class="btn-group btn-group-sm" id="editLengthToggle">
          <label class="btn btn-default">
            <input type="radio" name="editLengthMode" value="hot"  autocomplete="off" checked> Hot
          </label>
          <label class="btn btn-default">
            <input type="radio" name="editLengthMode" value="cold" autocomplete="off"> Cold
          </label>
        </div>
      </div>

      <!-- Inputs: editable one depends on the toggle -->
      <label class="form-label">Lengths</label>
      <div class="pair-2">
        <div>
          <label style="display:block; margin-bottom:4px;">Hot Length</label>
          <input id="editHotInput"  class="field-input form-control" type="number">
        </div>
        <div>
          <label style="display:block; margin-bottom:4px;">Cold Length</label>
          <input id="editColdInput" class="field-input form-control" type="number">
        </div>
      </div>

    </div>
  </div>

  <div class="modal-footer">
    <button id="saveEditLengthBtn" class="btn btn-primary">Save</button>
    <button id="savePrintEditLengthBtn" class="btn btn-primary">Save &amp; Print</button>
    <button class="btn btn-default" data-dismiss="modal">Cancel</button>
  </div>

</script>




<script id="ProductsViewPositionTemplate" type="text/x-handlebars-template">
    <div draggable="true" class="product-box" >
        <h5 data-bind="text:ProductNumber," class="product-number"></h5>   
    </div>  
</script>
    
<script id="reassing_products_template" type="text/x-handlebars-template">
    <div class="modal-header">
             <h3>Reassign Products</h3>
    
    </div>
    <div style="max-height:750px;padding-bottom:0;padding-top:0;" class="modal-body">
        <div style="max-height:650px;padding-bottom:0;" class="modal-body">
            
            
            <div class="row-fluid" style="text-align:center;">
                <div class="span2"></div>
                <div class="span2">
                     <label class="control-label"> Target Heat
                     </label>
                </div>
               <div class="span6">
                <div style="text-align: left;" class="destination-heat" >      
                
                        <div id="heat-destination-picker-multi-select"></div>
                
                </div>
             </div>
            </div> 
           <div class="row-fluid" style="margin-top: 10px;">
            <div class="span6"></div><i class="fa fa-arrow-up fa-2x" aria-hidden="true"></i>

           </div>
            <div class="row-fluid source-heat-container" style="text-align:center;">
                 <div class="span2"></div>
                <div class="span2">
                     <label class="control-label"> Source Heat
                     </label>
                </div>
                <div class="span6">
             <div style="text-align: left;" class="source-heat">  
                     <div id="heat-source-picker-multi-select"></div>
             </div>
             </div>

                <div class="source-products-container items-grid-container">
                </div>
             </div> 
        </div>
      
    </div>
    <div class="modal-footer">

        <button id="acceptReassignBtn" class="btn btn-primary">
            <asp:Localize runat='server' meta:resourcekey='accept_btn_label' />
        </button>
        
        <button id="cancelReassignBtn" class="btn" data-dismiss="modal">
            <asp:Localize runat='server' meta:resourcekey='cancel_btn_label' />
        </button>

    </div>
</script>

<script id="print_confirmation_modal" type="text/x-handlebars-template">
  <div class="modal-header">
    <h5 id="offcanvasRightLabel">Print Tag Confirmation</h5>
    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
  </div>
<div class="modal-body">
  <div class="form-grid">

    <!-- Product Number -->
    <label class="form-label">
      <asp:Localize runat="server" meta:resourcekey="productNumber_label" />
    </label>
    <input class="field-input form-control" type="text"
           data-bind="value: productNumber" style="text-align:center;" disabled>

    <!-- Reason -->
    <label class="form-label">
      <asp:Localize runat="server" meta:resourcekey="reasonPhrases_combo_label" />
      <span class="required-star">*</span>
    </label>
    <select class="field-select form-control" data-bind="value: reasonPhraseId, options: reasonPhrases"></select>

    <!-- Printer / Employee (two columns on the right) -->
    <label class="form-label printerLabel">
      <asp:Localize runat="server" meta:resourcekey="printer_combo_label" />
      <span class="required-star">*</span>
    </label>
    <div class="pair-2">
      <select class="field-select form-control printer-select"
data-bind="value: printerId, options: printers"></select>

      <div>
        <label class="form-label" style="display:block; margin-bottom:4px;">
          <asp:Localize runat="server" meta:resourcekey="employee_combo_label" />
          <span class="required-star">*</span>
        </label>
        <input class="field-input form-control" type="number" data-bind="value: employeeNumber">
        <span id="warning" style="display:none;">This field is required.</span>
      </div>
    </div>
  </div>
  <div class="length-note alert alert-info mt-4" role="alert">
    <strong> Printing COLD length.</strong></div>

    <!-- Hot & Cold Lengths -->
    <label class="form-label">Lengths</label>
    <div class="pair-2">
      <div>
        <label style="display:block; margin-bottom:4px;">Hot Length</label>
        <input id="pieceLengthInput" class="field-input form-control" type="number"
               data-bind="value: pieceLength">
      </div>
      <div>
        <label style="display:block; margin-bottom:4px;">Cold Length</label>
        <input id="coldLengthInput" class="field-input form-control" type="number"
               >
      </div>
    </div>

    <!-- Comments (full width) -->
    <label class="form-label">Comments</label>
    <textarea class="print-comments form-control full"
              data-bind="value: comments"
              placeholder="Add any additional comments…"></textarea>

  </div>
</div>

  <div class="modal-footer noselect">
    <div class="footer-btn-bar">
      <button id="acceptBtn" class="btn btn-primary w-half">
        Print
      </button>
      <button id="cancelBtn" class="btn btn-cancel w-half" data-dismiss="modal">
        <asp:Localize runat='server' meta:resourcekey='cancel_btn_label' />
      </button>
    </div>
  </div>
</script>





























