﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" meta:resourcekey="PageResource1" %>

<%@ Import Namespace="System.IO" %>
<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>

<script runat="server">
    String version = WebAppVersion.GetWebAppVersion();

    //@Override this is suggested by Microsoft, overriding the initialize culture function (that is
    //automatically called by the aspx.
    //Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
    //(English).
    protected override void InitializeCulture()
    {
        HttpCookie lang = Request.Cookies["siteLanguage"];

        String selectedLanguage = (lang != null) ? lang.Value : "en";
        UICulture = selectedLanguage;
        Culture = selectedLanguage;

        Thread.CurrentThread.CurrentCulture = CultureInfo.CreateSpecificCulture(selectedLanguage);
        Thread.CurrentThread.CurrentUICulture = new CultureInfo(selectedLanguage);
        base.InitializeCulture();
    }
</script>

<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).

    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<%--view template starts here (will be appended inside a row-fluid)--%>

<link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/lib/backgrid.css")%>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/extensions/valid-limit-cell/backgrid-valid-limit-cell.css") %>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/app/custom-screens/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + "/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + ".css")%>" rel="stylesheet" />

<div class="row-fluid subnavbar fixed-subnavbar" style="margin-bottom: 0px;">
    <div class="row-fluid form-inline">
        <div class="span10">
           <label style="margin-left:10px;margin-bottom:0 !important; ">
                <asp:Localize runat="server" meta:resourcekey="furnace_label" /> 
                    <select data-bind=" value: furnaceCode, options: furnaces" style="width:100px;margin-top:0px;">
                    </select>
            </label>
            <button id="refreshBtn" class="btn btn-primary" title="<asp:localize runat=server meta:resourcekey=refresh_btn_title />">
                <i class="fa fa-refresh"></i>
            </button>
        </div>
    </div>
</div>

<div class="row-fluid screen-content">
    <div class="no-data-poster row-fluid text-center animated fadeIn" data-bind="classes: { hide: any(hasData, isLoading), }" style="height:500px;">
        <div class="row-fluid" style="position:relative;top:100px;">
            <i class="fw-icon-circle-blank fw-icon-4x" style="font-size:115px;"></i>
        </div>
        <div class="row-fluid" style="position:relative;top:115px;">
            <h3 style="font-size:50px;">
                <asp:localize runat="server" meta:resourcekey="no_data_available" />
            </h3>
        </div>
    </div>
    <div class="no-data-poster row-fluid text-center animated fadeIn" data-bind="classes: { hide: not(isLoading), }" style="height:500px;">
        <div class="row-fluid" style="position:relative;top:100px;">
            <i class="fa fa-cog fw-icon-4x fa-spin" style="font-size:115px;"></i>
        </div>
        <div class="row-fluid" style="position:relative;top:115px;">
            <h3 style="font-size:50px;">
                <asp:localize runat="server" meta:resourcekey="loading_data" />
            </h3>
        </div>
    </div>
    <div class="items-grid-container row-fluid infinite-container" data-bind="classes: { hide: any(not(hasData), isLoading), }"></div>
</div>


<script id="actions_cell_template" type="text/x-handlebars-template">
    <div class="text-center">
        <button data-toggle="tooltip" data-placement="bottom" data-cell-action="EDIT_DETAILS" title="<asp:Localize runat=server meta:resourcekey=edit_details_title />" class="btn btn-cell-action btn-small btn-edit-details"><i class="fa fa-pencil-square-o"></i></button>
    </div>
</script>


<script id="delays_declare_modal" type="text/x-handlebars-template">
    <div class="modal-header" >    
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
        <h4>
            <span data-bind="text: title" style="font-weight:bold;"></span>
        </h4>    
    </div>
    <div class="modal-body">
        <div style="padding-bottom:0;" class="modal-body">
            <div class="row-fluid">
                 <div class="row-fluid" style="margin-bottom: 10px !important;"> 
                     <div class="span2">
                        <label style="margin-bottom:0 !important;margin-left:-10px; font-weight:bold">
                            <asp:Localize runat="server" meta:resourcekey="datetime_label" /> 
                        </label>
                    </div>
                    <div class="span4" style="margin-left:10px;">
                        <div class="form-group">
                            <div class="input-group form-inline">
                                <label>
                                    <asp:localize runat="server" meta:resourcekey="delays_declare_delay_start_label" />
                                </label>
                                <label for="dateModal" class="input-prepend"><span class="add-on"><i class="icon-calendar"></i></span></label>
                                <input type="text" id="dateModal" class="form-control" data-bind="value: dateModal">
                            </div>
                        </div>
                    </div>
                    <div class="span4" style="margin-left:-5px;">
                        <div class="form-group">
                            <div class="input-group form-inline bootstrap-timepicker timepicker">
                                <label for="timeModal" class="input-prepend"><span class="add-on"><i class="icon-time"></i></span></label>
                                <input type="text" id="timeModal" class="form-control" data-bind="value: timeModal">
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row-fluid">
                    <div class="span2" data-bind="classes: {hide: not(hasEquipmentTypeId),}">
                        <label style="margin-bottom:0 !important;margin-left:-10px; font-weight:bold">
                            <asp:Localize runat="server" meta:resourcekey="equipment_label" /> 
                        </label>
                    </div>
                    <div class="span10" data-bind="classes: {hide: not(hasEquipmentTypeId),}">
                         <select id="spares" data-bind=" value: equipmentId, options: equipments, optionsDefault: { label: '<asp:localize runat=server meta:resourcekey=equipment_none_opt />', value: 'null'}" style="width:300px;margin-top:0px;" >
                            
                         </select>
                    </div>
                </div>
                <div class="row-fluid">
                    <div class="span2">
                        <label style="margin-bottom:0 !important; margin-left:-10px; font-weight:bold">
                            <asp:Localize runat="server" meta:resourcekey="equipment_comments_label" /> 
                        </label>
                    </div>
                    <div class="span10">
                         <textarea data-bind="value: comments, enabled: not(processing)," maxlength="400" style="width:285px;height:90px;" placeholder="<asp:localize runat=server meta:resourcekey=electrode_change_modal_new_electrode_comments_placeholder />" data-select-on-focus></textarea>
                     </div>
                </div>  
               
                <label style="font-weight:bold;margin-left:-10px;"> 
                    <asp:Localize runat="server" meta:resourcekey="last_change_modal_label" />
                </label>
                <hr>
                <div class="row-fluid">
                    <div class="span1">
                          <asp:Localize runat="server" meta:resourcekey="equipment_type_modal_label" /> 
                    </div>
                    <div class="span11">
                        <span data-bind="text:equipmentTypeName" style="font-weight:bold;"></span>
                    </div>                   
                </div>
                <div class="row-fluid">
                    <div class="span6">
                        <div class="span4">
                            <asp:Localize runat="server" meta:resourcekey="last_datetime_modal_label" /> 
                        </div>
                        <div class="span8">
                            <span data-bind="text: momentFormat(lastChange, 'YYYY-MM-DD HH:mm:ss', 'YYYY-MM-DD HH:mm:ss')" style="font-weight:bold;"></span>
                        </div>
                    </div>
                    <div class="span6">  
                        <div class="span3">
                              <asp:Localize runat="server" meta:resourcekey="counts_modal_label" /> 
                        </div>
                        <div class="span4">
                            <span data-bind="text:counts" style="font-weight:bold;"></span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="modal-footer">
        <div class="modal-status-msg-container pull-left">
            <div class="modal-status-msg hide" data-bind="toggle: notEquals(errorMsg, ''),">
                <span data-bind="text: errorMsg, attr: { title: errorMsg, }," style="color:#ff0000;font-size:16px;"></span>
            </div>
            <div class="modal-status-msg hide" data-bind="toggle: processing,">
                <asp:Localize runat='server' meta:resourcekey='processing_msg' />
                <i class="fa fa-cog fa-spin"></i>
            </div>
        </div>
        <button id="acceptBtn" class="btn btn-primary" data-bind="enabled: not(processing),">
            <asp:Localize runat='server' meta:resourcekey='accept_btn_label' />
        </button>
        <button id="cancelBtn" class="btn" data-dismiss="modal" data-bind="enabled: not(processing),">
            <asp:Localize runat='server' meta:resourcekey='cancel_btn_label' />
        </button>
    </div>
</script>