﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" meta:resourcekey="PageResource1" %>

<%@ Import Namespace="System.IO" %>
<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>

<script runat="server">
    String version = WebAppVersion.GetWebAppVersion();

    //@Override this is suggested by Microsoft, overriding the initialize culture function (that is
    //automatically called by the aspx.
    //Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
    //(English).
    protected override void InitializeCulture()
    {
        HttpCookie lang = Request.Cookies["siteLanguage"];

        String selectedLanguage = (lang != null) ? lang.Value : "en";
        UICulture = selectedLanguage;
        Culture = selectedLanguage;

        Thread.CurrentThread.CurrentCulture = CultureInfo.CreateSpecificCulture(selectedLanguage);
        Thread.CurrentThread.CurrentUICulture = new CultureInfo(selectedLanguage);
        base.InitializeCulture();
    }
</script>

<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).

    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<%--view template starts here (will be appended inside a row-fluid)--%>

<link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/lib/backgrid.css")%>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/extensions/valid-limit-cell/backgrid-valid-limit-cell.css") %>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/assets/libs/js/autocomplete/backbone.autocomplete.css") %>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/app/custom-screens/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + "/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + ".css")%>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/assets/libs/js/multiselect/virtual-select.min.css") %>" rel="stylesheet" />

<div class="row-fluid subnavbar fixed-subnavbar" style="margin-bottom: 0px;">
    <div class="row-fluid form-inline">
        <div class="span12 row-fluid">
            <div class="span4">                
                <div style="text-align: left;">
                    <button id="backNavBtn" style="margin-left:5px;" class="btn btn-nav btn-primary" data-bind="classes:{hide: hideNavitaionBtns}">
                        <asp:Localize runat="server" meta:resourcekey="back_item_btn_label" />
                    </button>          
                    <label class="control-label" style="width:200px;">
                         <div id="heat-picker-multi-select"></div>
                   </label>
                    <button id="forwardNavBtn" class="btn btn-nav btn-primary" data-bind="classes:{hide: hideNavitaionBtns}">
                            <asp:Localize runat="server" meta:resourcekey="forward_item_btn_label" />
                    </button>
                    <button id="goRealTimeBtn" class="btn btn-nav btn-primary" data-bind="classes:{hide: realTimeData}">
                            <asp:Localize runat="server" meta:resourcekey="go_real_time_item_btn_label" />
                    </button>
                </div>
                
        
           
            </div>
            <div class="span6">
                <div class="navigation-buttons"  data-bind="classes: { hide: any(not(hasData), isLoading), }" style="margin-left:-30px;"></div>
            </div>
            <div class="span2">
                <button style="margin-top:0; margin-left:10px; margin-right:10px;" class="btn btn btn-success pull-right pull-right" data-bind="classes:{hide: hideExcelBtn}" type="button">
                    <span class="excel-export-state fa fa-file-excel-o"></span>
                    <img class="loading-state hide" style="width:20px;height:20px;" src="<%= ResolveUrl("~/assets/img/spinner20.gif") %>" />
                </button>
                <button id="refreshBtn" class="btn btn-primary pull-right" style="margin-right: 10px;" title="<asp:localize runat=server meta:resourcekey=refresh_btn_title />">
                    <i class="fa fa-refresh"></i>
                </button>
                
            </div>
       </div>
    </div>
</div>

<div class="row-fluid screen-content">
     <div class="no-data-poster row-fluid text-center animated fadeIn" data-bind="classes: { hide: any(hasData, isLoading), }" style="height:500px;">
        <div class="row-fluid" style="position:relative;top:100px;">
            <i class="fw-icon-circle-blank fw-icon-4x" style="font-size:115px;"></i>
        </div>
        <div class="row-fluid" style="position:relative;top:115px;">
            <h3 style="font-size:50px;">
                <asp:localize runat="server" meta:resourcekey="no_data_available" />
            </h3>
        </div>
    </div>
    <div class="no-data-poster row-fluid text-center animated fadeIn" data-bind="classes: { hide: not(isLoading), }" style="height:500px;">
        <div class="row-fluid" style="position:relative;top:100px;">
            <i class="fa fa-cog fw-icon-4x fa-spin" style="font-size:115px;"></i>
        </div>
        <div class="row-fluid" style="position:relative;top:115px;">
            <h3 style="font-size:50px;">
                <asp:localize runat="server" meta:resourcekey="loading_data" />
            </h3>
        </div>
    </div>
    <!---Tables--->


    <div class="grids-containers" data-bind="classes: { hide: any(not(hasData), isLoading), }">
        <div class="lab-real-time-grid-container items-grid-container" id="lab-real-time-grid"></div>
    </div>

      
</div>


<script id="modal" type="text/x-handlebars-template">
    <div class="modal-header" >    
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
        <h4 data-bind="classes: { hide: showComments, }">
            <asp:Localize runat="server" meta:resourcekey="modal_title" /> 
        </h4>    
        <h4 data-bind="classes: { hide: not(showComments), }">
            <asp:Localize runat="server" meta:resourcekey="modal_comments_title" /> 
        </h4>    
    </div>
    <div class="modal-body" style="height:30% !important;">
        
        <div class="process-comments-grid-container items-modal-grid-container" data-bind="classes: { hide: not(showComments), }" style="margin-bottom: 2% !important;max-height:80%"></div>

                
        <div class="row-fluid" style="margin-bottom: 30px !important;" data-bind="classes: { hide: showComments, }"> 
            <div class="span2">
                <label style="margin-bottom:0 !important;margin-left:-10px; font-weight:bold">
                    <asp:Localize runat="server" meta:resourcekey="datetime_label" /> 
                </label>
            </div>
            <div class="span4" style="margin-left:10px;">
                <div class="form-group">
                    <div class="input-group form-inline">
                        <label>
                            <asp:localize runat="server" meta:resourcekey="date_label" />
                        </label>
                        <label for="dateModal" class="input-prepend"><span class="add-on"><i class="icon-calendar"></i></span></label>
                        <input type="text" id="dateModal" class="form-control" data-bind="value: dateModal">
                    </div>
                </div>
            </div>
            <div class="span4" style="margin-left:-5px;">
                <div class="form-group">
                    <div class="input-group form-inline bootstrap-timepicker timepicker">
                        <label for="timeModal" class="input-prepend"><span class="add-on"><i class="icon-time"></i></span></label>
                        <input type="text" id="timeModal" class="form-control" data-bind="value: timeModal">
                    </div>
                </div>
            </div>
        </div>
        
            

        <label style="font-weight:bold;margin-left:-10px;"> 
            <asp:Localize runat="server" meta:resourcekey="row_information_label" />
        </label>
        
        <hr>


        <div class="row-fluid">
            <div class="span2">
                    <asp:Localize runat="server" meta:resourcekey="grade_name_label" /> 
            </div>
            <div class="span4">
                <span data-bind="text:gradeName" style="font-weight:bold;"></span>
            </div>
                <div class="span1">
                    <asp:Localize runat="server" meta:resourcekey="heat_name_label" /> 
            </div>
            <div class="span4">
                <span data-bind="text:heatName" style="font-weight:bold;"></span>
            </div>
        </div>
        <div class="row-fluid">
            <div class="span2">  
                <asp:Localize runat="server" meta:resourcekey="location_label" /> 
            </div>                 
            <div class="span4">
                <span data-bind="text:TypeCode" style="font-weight:bold;"></span>
            </div>
                   
            <div class="span1">
                    <asp:Localize runat="server" meta:resourcekey="sample_id_label" /> 
            </div>
            <div class="span4">
                <span data-bind="text:SampleIdCode" style="font-weight:bold;"></span>
            </div>
        </div>


    </div>
    <div class="modal-footer">
        <div class="modal-status-msg-container pull-left">
            <div class="modal-status-msg hide" data-bind="toggle: notEquals(errorMsg, ''),">
                <span data-bind="text: errorMsg, attr: { title: errorMsg, }," style="color:#ff0000;font-size:16px;"></span>
            </div>
            <div class="modal-status-msg hide" data-bind="toggle: processing,">
                <asp:Localize runat='server' meta:resourcekey='processing_msg' />
                <i class="fa fa-cog fa-spin"></i>
            </div>
        </div>
        <button id="acceptBtn" class="btn btn-primary" data-bind="enabled: not(processing),classes: { hide: showComments, }">
            <asp:Localize runat='server' meta:resourcekey='accept_btn_label' />
        </button>
        <button id="cancelBtn" class="btn" data-dismiss="modal" data-bind="enabled: not(processing),">
            <asp:Localize runat='server' meta:resourcekey='cancel_btn_label' />
        </button>
    </div>
</script>


<script id="actions_cell_template" type="text/x-handlebars-template">
    <div class="text-center">
         <button data-toggle="tooltip" data-placement="bottom" data-cell-action="INFO" title="<asp:Localize runat=server meta:resourcekey=edit_details_title />" class="btn btn-cell-action btn-small btn-edit-details"><i class="fa fa-info-circle"></i></button>
    </div>
</script>