﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" meta:resourcekey="PageResource1" %>

<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>
<script runat="server">
//@Override this is suggested by Microsoft, overriding the initialize culture function (that is
//automatically called by the aspx.
//Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
//(English).
protected override void InitializeCulture()
{
    HttpCookie lang = Request.Cookies["siteLanguage"]; 
    
    String selectedLanguage = (lang != null) ? lang.Value : "en";
    UICulture = selectedLanguage ;
    Culture = selectedLanguage ;

    Thread.CurrentThread.CurrentCulture = 
        CultureInfo.CreateSpecificCulture(selectedLanguage);
    Thread.CurrentThread.CurrentUICulture = new 
        CultureInfo(selectedLanguage);
    base.InitializeCulture();
}
</script>
<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).
    
    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<%--view template starts here (will be appended inside a row-fluid)--%>

<style>
    .ui-datepicker {
        z-index:1052 !important;
    }

    .config-form {
        margin: 0 0 10px 0 !important;
    }
    .config-group {
        float:left;
        margin-right:20px;
    }
    .config-form label.control-label {
        float:left;
        width: auto;
        margin-top: 4px;
        margin-right: 5px;
    }
    .config-form input[type='text'],
    .config-form select {
        float:left;
        /*margin-left:6px;*/
    }
    /*.config-form input[type='text'] {
        width:60px;
    }*/
    .config-form span {
        width:80px;
        float:left;
        margin:4px 7px 0 7px;
        font-weight:bold;
    }

    .nomargin {
        margin:0 !important;
    }

    .error {
        color: #F14848;
    }
    .ok {
        color: #0B9E0B;
    }
    .timeout {
        color: #479DC4;
    }

    .toggleImportCfgBtn {
        float: left;
        margin-top: 5px;
        width:16px;
        cursor: pointer;
    }

    .toggleExportCfgBtn {
        float: left;
        margin-top: 5px;
        width:16px;
        cursor: pointer;
    }

</style>

<div class="row-fluid">
    <div class="offset3 span9 subnavbar fixed-subnavbar" style="background-color:#fff;border-bottom: none;">
        <div id="generalImportCfgContainer" class="row-fluid"></div>
        <div id="generalExportCfgContainer" class="row-fluid"></div>
        <div class="hero-unit" style="padding:10px;margin-top:20px;">
            <h4><asp:Localize runat="server" meta:resourcekey="clear_data_title" /></h4>
            <p style="margin-top:0;font-size:15px;">
                <asp:Localize runat="server" meta:resourcekey="clear_data_description" />
            </p>
            <p class="text-center" style="margin-top:5px;">
                <button id="clearAdditionalImportedDataBtn" class="btn btn-primary btn-large">
                    <asp:Localize runat="server" meta:resourcekey="clear_data_btn_label" />
                </button>
            </p>
        </div>
    </div>
</div>

<script id="generalExportConfigTemplate" type="text/x-handlebars-template">
    <div class="row-fluid" style="border-bottom: 1px solid #ccc;">
        <h4 class="pull-left"><asp:Localize runat="server" meta:resourcekey="export_general_config_title" /></h4>
        <div style="margin:5px 0 0 10px;float:left;">
            <%--<div class="toggleExportCfgBtn exportCfgCollapse" title="Colapsar">
                <i class="fa fa-chevron-down"></i>
            </div>--%>
            <%--<div class="toggleExportCfgBtn exportCfgExpand" title="Expandir" style="display:none;">
                <i class="fa fa-chevron-right"></i>
            </div>--%>
            <div style="float:left;margin-left:30px;">
                <button id="editGeneralCfgBtn" class="btn btn-default" data-bind="clickSet: 'editing', clickSetValue: true, classes: { hide: editing, }">
                    <i class="fw-icon-edit fw-icon-large"></i>
                </button>
                <div class="pull-left" data-bind="classes: { hide: not(editing), }">
                    <button id="saveGeneralCfgBtn" style="margin-left:10px;" class="btn btn-success">
                        <asp:Localize runat="server" meta:resourcekey="export_save_general_cfg_btn_label" />
                    </button>
                    <button id="cancelGeneralCfgBtn" data-bind="clickSet: 'editing', clickSetValue: false," style="margin-left:10px;" class="btn btn-default">
                        <asp:Localize runat="server" meta:resourcekey="export_cancel_general_cfg_btn_label" />
                    </button>
                </div>
            </div>
        </div>
        <div style="margin:5px 10px 0 10px;float:right;" data-bind="classes: { error: equals(lastRunStatus, 'ERROR'), ok: equals(lastRunStatus, 'OK'), timeout: equals(lastRunStatus, 'TIMEOUT'), },">
            <i class="fa pull-left no-text-select" data-bind="classes: { 'fa-times': equals(lastRunStatus, 'ERROR'), 'fa-check': equalsAny(lastRunStatus, 'OK', 'TIMEOUT'), }," style="margin-right:0;font-size:32px;"></i>
            <div class="pull-left" style="margin-left:10px;height:32px;line-height:32px;">
                <span class="text-3dots" style="max-width:470px;display:block;" data-bind="text: format('<asp:localize runat=server meta:resourcekey=export_last_run_msg_label />: $1, $2', coalesce(momentFormat(lastRunTimestamp, 'YYYY-MM-DD HH:mm:ss.SSS', 'YYYY-MM-DD HH:mm:ss'), '-'), coalesce(lastRunMessageText, '-')), attr: { title: coalesce(lastRunMessageText, '-'), },"></span>
            </div>
        </div>
    </div>
    <%--<div class="row-fluid exportCfgCollapse" style="margin-top:10px;">--%>
    <div class="row-fluid" style="margin-top:10px;">
        <div class="span12">
            <div class="form pull-left span12">
                <div class="form-inline span12 config-form">
                    <div class="config-group">
                        <label class="control-label" data-bind="classes: { hide: editing, },">
                            <i class="fa" data-bind="classes: { 'fa-check-square-o': active, 'fa-square-o': not(active), },"></i>
                            <asp:localize runat="server" meta:resourcekey="export_config_active_label" />
                        </label>
                        <label class="control-label" data-bind="classes: { hide: not(editing), },">
                            <input type="checkbox" data-bind="checked: active" style="margin-top:-2px;" />
                            <asp:localize runat="server" meta:resourcekey="export_config_active_label" />
                        </label>
                    </div>
                    <div class="config-group">
                        <label class="control-label" for="intervalTbx">
                            <asp:localize runat="server" meta:resourcekey="export_config_interval_label" />:
                        </label>
                        <input type="text" id="intervalTbx" style="width:60px;" data-bind="value: read(intervalFormated), classes: { hide: not(editing), }," placeholder="<asp:Localize runat='server' meta:resourcekey='export_config_interval_place_holder' />" title="<asp:Localize runat='server' meta:resourcekey='export_config_interval_title' />" />
                        <span data-bind="text: intervalFormated, classes: { hide: editing, show: not(editing), },"></span>
                    </div>
<%--                    <div class="config-group">
                        <label class="control-label" for="timeoutTbx">
                            <asp:localize runat="server" meta:resourcekey="config_timeout_label" />:
                        </label>
                        <input type="text" id="timeoutTbx" data-bind="value: read(timeoutFormated), classes: { hide: not(editing), }," placeholder="<asp:Localize runat='server' meta:resourcekey='config_timeout_place_holder' />" title="<asp:Localize runat='server' meta:resourcekey='config_timeout_title' />" />
                        <span data-bind="text: timeoutFormated, classes: { hide: editing, show: not(editing), },"></span>
                    </div>--%>
                </div>
                <div class="form-inline span12 config-form">
                    <div class="config-group">
                        <label class="control-label" for="targetConnectionStringTbx">
                            <asp:localize runat="server" meta:resourcekey="export_config_target_con_string_label" />:
                        </label>
                        <input type="text" id="targetConnectionStringTbx" class="input input-xlarge" style="width:500px;" data-bind="value: targetConnectionString, classes: { hide: not(editing), }," />
                        <span class="text-3dots" style="width:500px;" data-bind="text: coalesce(targetConnectionString, '-'), classes: { hide: editing, show: not(editing), },"></span>
                    </div>
                </div>
                <div class="form-inline span12 config-form">
                    <div class="config-group">
                        <label class="control-label" for="userNameTbx">
                            <asp:localize runat="server" meta:resourcekey="export_config_user_name_label" />:
                        </label>
                        <input type="text" id="userNameTbx" class="input input-medium" style="width:80px;" data-bind="value: userName, classes: { hide: not(editing), }," />
                        <span data-bind="text: coalesce(userName, '-'), classes: { hide: editing, show: not(editing), },"></span>
                    </div>
                    <div class="config-group" data-bind="classes: { hide: not(editing), },">
                        <label class="control-label" for="userPasswordTbx">
                            <asp:localize runat="server" meta:resourcekey="export_config_user_password_label" />:
                        </label>
                        <input type="password" id="userPasswordTbx" class="input input-medium" style="width:80px;" data-bind="value: userPassword, classes: { hide: not(editing), }," />
                        <%--<span data-bind="text: coalesce(userPassword, '-'), classes: { hide: editing, show: not(editing), },"></span>--%>
                    </div>
                </div>
            </div>
        </div>
    </div>
</script>

<script id="generalImportConfigTemplate" type="text/x-handlebars-template">
    <div class="row-fluid" style="border-bottom: 1px solid #ccc;">
        <h4 class="pull-left"><asp:Localize runat="server" meta:resourcekey="import_general_config_title" /></h4>
        <div style="margin:5px 0 0 10px;float:left;">
            <%--<div class="toggleImportCfgBtn importCfgCollapse" title="Colapsar">
                <i class="fa fa-chevron-down"></i>
            </div>--%>
            <%--<div class="toggleImportCfgBtn importCfgExpand" title="Expandir" style="display:none;">
                <i class="fa fa-chevron-right"></i>
            </div>--%>
            <div style="float:left;margin-left:30px;">
                <button id="editGeneralCfgBtn" class="btn btn-default" data-bind="clickSet: 'editing', clickSetValue: true, classes: { hide: editing, }">
                    <i class="fw-icon-edit fw-icon-large"></i>
                </button>
                <div class="pull-left" data-bind="classes: { hide: not(editing), }">
                    <button id="saveGeneralCfgBtn" style="margin-left:10px;" class="btn btn-success">
                        <asp:Localize runat="server" meta:resourcekey="import_save_general_cfg_btn_label" />
                    </button>
                    <button id="cancelGeneralCfgBtn" data-bind="clickSet: 'editing', clickSetValue: false," style="margin-left:10px;" class="btn btn-default">
                        <asp:Localize runat="server" meta:resourcekey="import_cancel_general_cfg_btn_label" />
                    </button>
                </div>
            </div>
        </div>
        <div style="margin:5px 10px 0 10px;float:right;" data-bind="classes: { error: equals(lastRunStatus, 'ERROR'), ok: equals(lastRunStatus, 'OK'), timeout: equals(lastRunStatus, 'TIMEOUT'), },">
            <i class="fa pull-left no-text-select" data-bind="classes: { 'fa-times': equals(lastRunStatus, 'ERROR'), 'fa-check': equalsAny(lastRunStatus, 'OK', 'TIMEOUT'), }," style="margin-right:0;font-size:32px;"></i>
            <div class="pull-left" style="margin-left:10px;height:32px;line-height:32px;">
                <span class="text-3dots" style="max-width:470px;display:block;" data-bind="text: format('<asp:localize runat=server meta:resourcekey=import_last_run_msg_label />: $1, $2', coalesce(momentFormat(lastRunTimestamp, 'YYYY-MM-DD HH:mm:ss.SSS', 'YYYY-MM-DD HH:mm:ss'), '-'), coalesce(lastRunMessageText, '-')), attr: { title: coalesce(lastRunMessageText, '-'), },"></span>
            </div>
        </div>
    </div>
    <%--<div class="row-fluid importCfgCollapse" style="margin-top:10px;">--%>
    <div class="row-fluid" style="margin-top:10px;">
        <div class="span12">
            <div class="form pull-left span12">
                <div class="form-inline span12 config-form">
                    <div class="config-group">
                        <label class="control-label" data-bind="classes: { hide: editing, },">
                            <i class="fa" data-bind="classes: { 'fa-check-square-o': active, 'fa-square-o': not(active), },"></i>
                            <asp:localize runat="server" meta:resourcekey="import_config_active_label" />
                        </label>
                        <label class="control-label" data-bind="classes: { hide: not(editing), },">
                            <input type="checkbox" data-bind="checked: active" style="margin-top:-2px;" />
                            <asp:localize runat="server" meta:resourcekey="import_config_active_label" />
                        </label>
                    </div>
                    <div class="config-group">
                        <label class="control-label" for="intervalTbx">
                            <asp:localize runat="server" meta:resourcekey="import_config_interval_label" />:
                        </label>
                        <input type="text" id="intervalTbx" style="width:60px;" data-bind="value: read(intervalFormated), classes: { hide: not(editing), }," placeholder="<asp:Localize runat='server' meta:resourcekey='import_config_interval_place_holder' />" title="<asp:Localize runat='server' meta:resourcekey='import_config_interval_title' />" />
                        <span data-bind="text: intervalFormated, classes: { hide: editing, show: not(editing), },"></span>
                    </div>
<%--                    <div class="config-group">
                        <label class="control-label" for="timeoutTbx">
                            <asp:localize runat="server" meta:resourcekey="config_timeout_label" />:
                        </label>
                        <input type="text" id="timeoutTbx" data-bind="value: read(timeoutFormated), classes: { hide: not(editing), }," placeholder="<asp:Localize runat='server' meta:resourcekey='config_timeout_place_holder' />" title="<asp:Localize runat='server' meta:resourcekey='config_timeout_title' />" />
                        <span data-bind="text: timeoutFormated, classes: { hide: editing, show: not(editing), },"></span>
                    </div>--%>
                </div>
                <div class="form-inline span12 config-form">
                    <div class="config-group">
                        <label class="control-label" for="targetConnectionStringTbx">
                            <asp:localize runat="server" meta:resourcekey="import_config_target_con_string_label" />:
                        </label>
                        <input type="text" id="targetConnectionStringTbx" class="input input-xlarge" style="width:500px;" data-bind="value: targetConnectionString, classes: { hide: not(editing), }," />
                        <span class="text-3dots" style="width:500px;" data-bind="text: coalesce(targetConnectionString, '-'), classes: { hide: editing, show: not(editing), },"></span>
                    </div>
                </div>
                <div class="form-inline span12 config-form">
                    <div class="config-group">
                        <label class="control-label" for="userNameTbx">
                            <asp:localize runat="server" meta:resourcekey="import_config_user_name_label" />:
                        </label>
                        <input type="text" id="userNameTbx" class="input input-medium" style="width:80px;" data-bind="value: userName, classes: { hide: not(editing), }," />
                        <span data-bind="text: coalesce(userName, '-'), classes: { hide: editing, show: not(editing), },"></span>
                    </div>
                    <div class="config-group" data-bind="classes: { hide: not(editing), },">
                        <label class="control-label" for="userPasswordTbx">
                            <asp:localize runat="server" meta:resourcekey="import_config_user_password_label" />:
                        </label>
                        <input type="password" id="userPasswordTbx" class="input input-medium" style="width:80px;" data-bind="value: userPassword, classes: { hide: not(editing), }," />
                        <%--<span data-bind="text: coalesce(userPassword, '-'), classes: { hide: editing, show: not(editing), },"></span>--%>
                    </div>
                </div>
            </div>
        </div>
    </div>
</script>
