﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" meta:resourcekey="PageResource1" %>

<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>
<script runat="server">
//@Override this is suggested by Microsoft, overriding the initialize culture function (that is
//automatically called by the aspx.
//Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
//(English).
protected override void InitializeCulture()
{
    HttpCookie lang = Request.Cookies["siteLanguage"]; 
    
    String selectedLanguage = (lang != null) ? lang.Value : "en";
    UICulture = selectedLanguage ;
    Culture = selectedLanguage ;

    Thread.CurrentThread.CurrentCulture = 
        CultureInfo.CreateSpecificCulture(selectedLanguage);
    Thread.CurrentThread.CurrentUICulture = new 
        CultureInfo(selectedLanguage);
    base.InitializeCulture();
}
</script>
<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).
    
    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<%--view template starts here (will be appended inside a row-fluid)--%>
<script id="main_template" type="text/x-handlebars-template">

<link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/lib/backgrid.css") %>" rel="stylesheet" />
    <link href="<%= ResolveUrl("~/app/custom-screens/delays/delays-simple/delays-simple.css") %>" rel="stylesheet" />

<style>

    .clickeable-row{
        cursor:pointer; 
    }

    .backgrid th{
        font-size:12px !important;
    }

    .backgrid tr{
        font-size:12px !important;
    }

    .backgrid tr td{
        overflow:visible !important; 
    }

    .backgrid tr td button{
        font-size:12px !important;
    }

    .toolbar-filter {
        display:inline-block;
    }

</style>

<div class="container-fluid">
    <div class="span12">
        <div class="row-fluid">
            <div style="margin-top:7%;" class="row-fluid loading-poster text-center">
                <div style="width:40%; margin: 0 auto;" class="progress progress-striped active">
                    <div class="bar" style="width: 100%;"></div>
                </div>
            </div>
            <div class="delays-grid-container hide">
            </div>
        </div>
    </div>
</div>

</script>

<script type="text/x-handlebars-template" id="subnavbar_controls">
    <div class="span6"></div>
    <div class="span6">
        <div class="subnavbar-right-toolbar">
            <div style="display: inline-block; height: 40px;" class="pull-right">
                <div class="toolbar-filter">
                    <label style="display: inline-block; margin-left: 10px; line-height: 40px;"><asp:Localize runat="server" meta:resourcekey="line_combo_label" /></label>
                    <select style="margin-left: 10px; top: 3px; position: relative;" data-bind="value: integer(lineProductionItemId), options: lines, optionsDefault: { label: '<asp:Localize runat=server meta:resourcekey=all_lines_label />', value: -1 }" id="selectbasic" name="selectbasic" class="input-medium">
                    </select>
                </div>
                <div class="toolbar-filter">
                    <label style="display: inline-block; margin-left: 10px; line-height: 40px;"><asp:Localize runat="server" meta:resourcekey="machine_combo_label" /></label>
                    <select style="margin-left: 10px; top: 3px; position: relative;" data-bind="value: integer(machineProductionItemId), options: machines, optionsDefault: { label: '<asp:Localize runat=server meta:resourcekey=all_machines_label />', value: -1 }" id="select1" name="selectbasic" class="input-medium">
                    </select>
                </div>
            </div>
        </div>
    </div>
</script>

