﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" meta:resourcekey="PageResource1" %>

<%@ Import Namespace="System.IO" %>
<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>

<script runat="server">
    String version = WebAppVersion.GetWebAppVersion();

    //@Override this is suggested by Microsoft, overriding the initialize culture function (that is
    //automatically called by the aspx.
    //Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
    //(English).
    protected override void InitializeCulture()
    {
        HttpCookie lang = Request.Cookies["siteLanguage"];

        String selectedLanguage = (lang != null) ? lang.Value : "en";
        UICulture = selectedLanguage;
        Culture = selectedLanguage;

        Thread.CurrentThread.CurrentCulture = CultureInfo.CreateSpecificCulture(selectedLanguage);
        Thread.CurrentThread.CurrentUICulture = new CultureInfo(selectedLanguage);
        base.InitializeCulture();
    }
</script>

<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).

    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<%--view template starts here (will be appended inside a row-fluid)--%>

<link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/lib/backgrid.css")%>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/extensions/valid-limit-cell/backgrid-valid-limit-cell.css") %>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/app/custom-screens/modules/elt/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + "/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + ".css")%>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/assets/libs/js/jstree/themes/default/style.css") %>" rel="stylesheet" />

<div class="row-fluid subnavbar fixed-subnavbar">
    <div class="row-fluid form-inline">
        <%--<label class="control-label" for="dateEndTbx">
            <asp:localize runat="server" meta:resourcekey="date_label" />
        </label>
        <label class="input-prepend">
            <span class="add-on"><i class="icon-calendar"></i></span>
            <input type="text" id="dateEndTbx" class="input-date" style="z-index:1000;" data-bind="value: momentFormat(date$, 'YYYY-MM-DD', '<asp:Localize runat=server meta:resourcekey=mmddyyyy_format />')">
        </label>--%>
        <label class="control-label" for="selectType"><asp:Localize runat="server" meta:resourcekey="types" /></label>
        <select style="width:200px" data-bind="value: integer(equipmentTypeId), options: equipmentTypes, optionsDefault: { label: '<asp:Localize runat=server meta:resourcekey=combo_all_option />', value: 0 }" id="selectType" class="subnavbar-select" name="selectType">
        </select>
        <label class="control-label" for="searchTbx">
            <asp:localize runat="server" meta:resourcekey="equipment_picker_label" />
        </label>
        <div class="input-prepend input-append ">
            <input type="text" id="searchTbx" style="width:300px;" data-bind="value: trim(equipmentName), events: ['change', 'keydown',]" placeholder="<asp:Localize runat=server meta:resourcekey=equipment_picker_place_holder />" data-select-on-focus/>
            <label class="btn btn-search-show" id="showSearchItemsBtn" for="searchTbx"><i class="fa fa-caret-down"></i></label>
        </div>
        <label class="control-label" for="selectStatus"><asp:Localize runat="server" meta:resourcekey="status" /></label>
        <select style="width:100px;margin-top:0px;" data-bind="value: equipmentStatusCode, options: equipmentStatusCodes, optionsDefault: { label: '<asp:Localize runat=server meta:resourcekey=combo_all_option />', value: null }" id="select1" class="subnavbar-select" name="selectType">
        </select>
        <label class="checkbox inline" style="display:inline-block;position:relative;top:-2px;margin-left: 10px;">
            <input type="checkbox" data-bind="checked: includeChildrens" />
            <span>
                <asp:Localize runat="server" meta:resourcekey="include_childrens_label" />
            </span>
        </label>
        <label class="checkbox inline" style="display:inline-block;position:relative;top:-2px;margin-left: 10px;">
            <input type="checkbox" data-bind="checked: showAbsolutes" />
            <span>
                <asp:Localize runat="server" meta:resourcekey="show_absolutes_label" />
            </span>
        </label>
        <button id="refreshBtn" class="btn btn-primary" style="margin-left:10px;" title="<asp:localize runat=server meta:resourcekey=refresh_btn_title />">
            <i class="fa fa-refresh"></i>
        </button>
        
        
    </div>
    
</div>
<div class="row-fluid screen-content">
    <div class="equipment-campaigns-grid-container infinite-container" style="margin-top:20px"></div>
</div>

<script id="actions_cell_template" type="text/x-handlebars-template">
    <div class="btn-group" style="float:left">
        <button class="configure-source-btn btn dropdown-toggle" data-toggle="dropdown" data-open="false" style="font-size: 12px;">
            <i style="font-size:16px;position:relative;top:3px;" class="fa fa-ellipsis-h"></i>
        </button>
        <ul class="dropdown-menu dropdown-menu-right" style="font-size: 12px;">
            <li style="cursor: pointer;">
                <a class="btn-dropdown-config-option" data-option="new-campaign">
                    <asp:Localize runat="server" meta:resourcekey="new_campaign_button_label" />
                </a>
            </li>
                {{HBExp '#ifEquals equipmentCurrentStatus \'OFFLINE\''}}
                    <li class="disabled">
                        <a class="btn-dropdown-config-option" >
                            <asp:Localize runat="server" meta:resourcekey="change_equipment_button_label" />
                        </a>
                    </li>
                    {{HBExp 'else'}}
                    <li style="cursor: pointer;">
                        <a class="btn-dropdown-config-option" data-option="change-equipment">
                            <asp:Localize runat="server" meta:resourcekey="change_equipment_button_label" />
                        </a>
                    </li>
                    {{HBExp '/ifEquals'}}

            {{HBExp '#ifEquals equipmentCurrentStatus \'READY\''}}
            <li class="disabled">
                <a class="btn-dropdown-config-option">
                    <asp:Localize runat="server" meta:resourcekey="set_as_ready_button_label" />
                </a>
            </li>
            {{HBExp 'else'}}
            <li style="cursor: pointer;">
                <a class="btn-dropdown-config-option" data-option="ready">
                    <asp:Localize runat="server" meta:resourcekey="set_as_ready_button_label" />
                </a>
            </li>
            {{HBExp '/ifEquals'}}
            {{HBExp '#ifEquals equipmentCurrentStatus \'ONLINE\''}}
            <li class="disabled">
                <a class="btn-dropdown-config-option">
                    <asp:Localize runat="server" meta:resourcekey="set_as_online_button_label" />
                </a>
            </li>
            {{HBExp 'else'}}
            <li style="cursor: pointer;">
                <a class="btn-dropdown-config-option" data-option="online">
                    <asp:Localize runat="server" meta:resourcekey="set_as_online_button_label" />
                </a>
            </li>
            {{HBExp '/ifEquals'}}
            {{HBExp '#ifEquals equipmentCurrentStatus \'INSHOP\''}}
            <li class="disabled">
                <a class="btn-dropdown-config-option">
                    <asp:Localize runat="server" meta:resourcekey="set_as_in_shop_button_label" />
                </a>
            </li>
            {{HBExp 'else'}}
            <li style="cursor: pointer;">
                <a class="btn-dropdown-config-option" data-option="inshop">
                    <asp:Localize runat="server" meta:resourcekey="set_as_in_shop_button_label" />
                </a>
            </li>
            {{HBExp '/ifEquals'}}

           
        </ul>
    </div>
</script>

<script id="new_campaign_modal_template" type="text/x-handlebars-template">
    <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
        <h3><asp:Localize runat=server meta:resourcekey=new_campaign_modal_title /></h3>
    </div>
    <div style="max-height:500px;padding-bottom:0;padding-top:0;" class="modal-body">
        <div class="row-fluid">
            <div class="form-horizontal">
                <div class="control-group no-margin-bottom">
                    <label class="control-label" style="font-weight:bold;">
                        <asp:Localize runat=server meta:resourcekey=name_label />
                    </label>
                    <label class="control-label" style="text-align:left; margin-left:15px; width:350px;" data-bind="text: trim(equipmentName)"></label>
                </div> 
                <div class="control-group no-margin-bottom">
                    <label class="control-label" style="font-weight:bold;">
                        <asp:Localize runat=server meta:resourcekey=status_label />
                    </label>
                    <label class="control-label" style="text-align:left; margin-left:15px;" data-bind="classes: { hide: not(equipmentCurrentStatusName) }, text: trim(equipmentCurrentStatusName)"></label>
                </div>
                <div class="control-group no-margin-bottom">
                    <label class="control-label" style="font-weight:bold;">
                        <asp:Localize runat=server meta:resourcekey=total_time_label />
                    </label>
                    <label class="control-label" style="text-align:left; margin-left:15px;" data-bind="text: duration(totalTime, 's', 'd h:m:s')"></label>
                </div> 
                <div class="control-group no-margin-bottom">
                    <label class="control-label" style="font-weight:bold;">
                        <asp:Localize runat=server meta:resourcekey=abs_total_time_label />
                    </label>
                    <label class="control-label" style="text-align:left; margin-left:15px;" data-bind="text: duration(absolute_totalTime, 's', 'd h:m:s')"></label>
                </div>
                <div class="control-group">
                    <h4><asp:localize runat="server" meta:resourcekey="counters_label" /></h4>
                    <div class="counters-grid-container infinite-container" style="margin-bottom:10px"></div>
                </div>
                <div class="control-group">
                    <label class="control-label" style="font-weight:bold;">
                        <asp:Localize runat=server meta:resourcekey=comments_label />
                    </label>
                    <textarea id="comments" data-bind="value: trim(comments)" style="width:200px; height:70px; margin-left:15px; resize: none;"></textarea>
                </div>
            </div>
        </div>
        <%--<div class="row-fluid screen-content">
            <h4><asp:localize runat="server" meta:resourcekey="counters_label" /></h4>
            <div class="counters-grid-container infinite-container" style="margin-bottom:10px"></div>
        </div>--%>
        <%--<div class="row-fluid form-inline">
            <label class="control-label" for="comments" style="vertical-align:top;"><asp:Localize runat="server" meta:resourcekey="comments_label" /></label>
            <textarea id="comments" class="auto-focus" data-bind="text: trim(coalesce(comments, ''))" style="resize: none"></textarea>
        </div>--%>
    </div>
    <div class="modal-footer" style="margin-bottom:20px;">
        <div class="modal-status-msg-container pull-left">
            <div class="modal-status-msg hide" data-bind="toggle: processing,">
                <asp:Localize runat='server' meta:resourcekey='new_campaign_modal_processing_msg' />
                <i class="fa fa-cog fa-spin"></i>
            </div>
        </div>
        <button id="acceptBtn" data-bind="enabled: all(notEquals(processing, true))," class="btn btn-primary">
            <asp:Localize runat='server' meta:resourcekey='new_campaign_modal_accept_btn_label' />
        </button>
        <button data-bind="enabled: notEquals(processing, true)" class="btn" data-dismiss="modal">
            <asp:Localize runat='server' meta:resourcekey='new_campaign_modal_cancel_btn_label' />
        </button>
    </div>
</script>

<script id="change_equipment_modal_template" type="text/x-handlebars-template">
    <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
        <h3><asp:Localize runat=server meta:resourcekey=assign_equipment_title /></h3>
    </div>
    <div style="max-height:400px;padding-bottom:0;padding-top:0;" <%--class="modal-body"--%>>
        <div style="max-height:400px;padding-bottom:0;overflow-y:inherit;" class="modal-body" >
            <div class="row-fluid">
                <form class="form-horizontal">
                    <div class="control-group" data-bind="classes: { hide: all( not(available)) },">
                        <label class="control-label" for="selectLocation"><asp:Localize runat="server" meta:resourcekey="location_label" /></label>
                        <label class="control-label" style="text-align:left; margin-left:15px;" data-bind="text:trim(name)"></label>
                    </div>
                    <div class="control-group">
                        <div class="span12" data-bind="classes: { hide: all( not(available)) },">
                            
                            <div class="jstreePreview" style="height:300px;overflow-y:auto; margin-top:20px;"></div>
                        </div>
                        <div class="span12" data-bind="classes: { hide: all( not(not(available))) },">
                            <label style="padding-top:5px; text-align:left;"  ><asp:Localize runat="server" meta:resourcekey="no_equipment_available" /></label>  
                        </div>
                    </div>
                    <%--
                    <div id="sources" class="row-fluid active tab-pane" style="max-height:350px;min-height:350px;overflow-y:auto;">
                        <div class="types-grid-container"></div>
                    </div>
                    --%>
                </form>
            </div>
        </div>
    </div>
    <div class="modal-footer">
        <div class="modal-status-msg-container pull-left">
            <div class="modal-status-msg hide" data-bind="toggle: processing,">
                <asp:Localize runat='server' meta:resourcekey='add_equipment_processing_msg' />
                <i class="fa fa-cog fa-spin"></i>
            </div>
        </div>
        <button id="acceptBtn" data-bind="enabled: all(notEquals(processing, true), modelId, name, not(equipmentId))," class="btn btn-primary">
            <asp:Localize runat='server' meta:resourcekey='add_equipment_accept_btn_label' />
        </button>
        <button data-bind="enabled: notEquals(processing, true)" class="btn" data-dismiss="modal">
            <asp:Localize runat='server' meta:resourcekey='add_equipment_cancel_btn_label' />
        </button>
    </div>

</script>