USE [IHBoxSystem]
GO
CREATE ROLE power_curtailment_read AUTHORIZATION dbo 
GO  

USE [IHBoxSystem]
GO
EXEC sp_addrolemember 'power_curtailment_read', 'admin'
GO

USE [IHBoxSystem]
GO
EXEC sp_addrolemember 'power_curtailment_read', 'SDI/australtek'
GO

EXECUTE sys.sp_addextendedproperty 
@level0type = N'USER' -- The object type
,@level0name = [power_curtailment_read] -- The role
,@name = N'securedsp-MES.GetPowerCurtailment' -- the procedure
,@value = N'' 
GO


declare @parent int, @result_routeId INT
select @parent=id from [FrontEnd].[Menu] where name='MES'

INSERT INTO [FrontEnd].[Routes]
		   ([Route]
		   ,[ModuleName]
		   ,[ModulePath]
		   ,[RequiredRole]
	   )
	 VALUES
		   (
		   '!/power-curtailment(/)'
		   , 'power-curtailment'
		   , 'custom-screens/power-curtailment/'
		   , 'power_curtailment_read'           
		   )
		   SET @result_routeId = @@IDENTITY
INSERT INTO [FrontEnd].[Menu]
		   ([Parent]
		   ,[Name]
		   ,[RouteID]
		   ,[SortOrder]
		   ,[Enabled]
		   ,[Visible]
		   ,[RequiredRole]
		   ,[Group]
		  )
	 VALUES
		   (
		   @parent
		   ,'Power Curtailment'
		   ,@result_routeId 
		   ,1
		   ,1
		   ,1
		   ,'power_curtailment_read'
		   ,NULL
		 )
GO

/*------------------------------------------------------Profiles------------------------------------------------------*/
USE [IHBoxSystem]
GO

DECLARE @ModuleId INT

INSERT INTO [SECURITY].[Modules]
		   ([Code]
		   ,[Name])
	 VALUES
		   ('power-curtailment'
		   ,'Power Curtailment')

		  SET @ModuleId = @@IDENTITY

INSERT INTO [SECURITY].[ModuleActions]
		   ([ModuleId]
		   ,[Code]
		   ,[Name]
		   ,[Role])
	 VALUES
		   (@ModuleId
		   ,'readWrite'
		   ,'Read/Write'
		   ,'power_curtailment_read')


	INSERT INTO [SECURITY].ModuleActions(ModuleId,Code,[Name],[Role])
	VALUES (@ModuleId,'read','Read','power_curtailment_read')
GO
/*------------------------------------------------------------------------------------------------------------------------*/


create table MES.PowerCurtailment (Id int identity(1,1),[Page] varchar(50), Equipment varchar(50), DownTimeType varchar(50), [Message] varchar(50), [Status] char(2),[Order] int)

go


USE [MES]
GO
/****** Object:  StoredProcedure [CAS].[GetProducts]    Script Date: 24/6/2022 09:35:05 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

ALTER PROCEDURE [MES].[GetPowerCurtailment]
AS
BEGIN

	-----------------------
	-- Common procedures variables
	-----------------------
	DECLARE 
		--Start of the message to be printed at the end of the procedure.
		@finishEndMSG VARCHAR(300),
		--The name of the procedure with its schema.
		@procName VARCHAR(300)

	SET @procName = OBJECT_SCHEMA_NAME(@@PROCID) + '.' + OBJECT_NAME(@@PROCID)
	
	SET @finishEndMSG =  @procName + ' finished.'
	
	-----------------------
	-- Begin Query
	-----------------------
	select [Equipment],[PJM],[PJMMaintenance],[AEP],[AEPMaintenance],[Emergency] from [MES].[GetPowerCurtailmentByEquipment]('Caster 1') order by [Order] asc
	select [Equipment],[PJM],[PJMMaintenance],[AEP],[AEPMaintenance],[Emergency] from [MES].[GetPowerCurtailmentByEquipment]('Caster 2') order by [Order] asc
	select [Equipment],[PJM],[PJMMaintenance],[AEP],[AEPMaintenance],[Emergency] from [MES].[GetPowerCurtailmentByEquipment]('LMF') order by [Order] asc
	select [Equipment],[PJM],[PJMMaintenance],[AEP],[AEPMaintenance],[Emergency] from [MES].[GetPowerCurtailmentByEquipment]('VTD-BOILER') order by [Order] asc
	select [Equipment],[PJM],[PJMMaintenance],[AEP],[AEPMaintenance],[Emergency] from [MES].[GetPowerCurtailmentByEquipment]('Refractory') order by [Order] asc
	
	-----------------------
	-- Finish procedure
	-----------------------
	PRINT @finishEndMSG

	RETURN 0

END

GO

EXEC [MES].[GetPowerCurtailment]


GO

USE [MES]
GO
/****** Object:  UserDefinedFunction [MES].[GetPowerCurtailmentByEquipment]    Script Date: 24/6/2022 11:09:40 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
ALTER FUNCTION [MES].[GetPowerCurtailmentByEquipment]
(
	@Equipment varchar(50)
)
RETURNS @dataT TABLE
(
	[Equipment] varchar(50)
	,PJM varchar(50)
	,PJMMaintenance varchar(50)
	, AEP varchar(50)
	,AEPMaintenance varchar(50)
	,[Emergency] varchar(50)
	,[Order] int
)
AS
BEGIN
	declare @temp table ([Equipment] varchar(200),PJM varchar(50),PJMMaintenance varchar(50), AEP varchar(200),AEPMaintenance varchar(50),[Emergency] varchar(50),[Order] int)

	declare @FilteredPowerCurtailmentByEquipement table (Equipment varchar(50), DownTimeType varchar(50), [Message] varchar(50), [Status] char(2),[Order] int)

	insert into @FilteredPowerCurtailmentByEquipement(Equipment,DownTimeType,[Message],[Status],[Order])
	select 
		Equipment
		,DownTimeType
		,[Message]
		,[Status]
		,[Order]
	from MES.PowerCurtailment
	where [Page] = @Equipment

	insert into @temp([Equipment],[Order])
	select distinct(Equipment),[Order] from @FilteredPowerCurtailmentByEquipement



	update t
		set t.AEP = p.[Message]

	from @temp t
	left join @FilteredPowerCurtailmentByEquipement p on p.Equipment = t.Equipment and p.DownTimeType = 'AEP'
	
	update t
		set t.AEPMaintenance = p.[Message]
	from @temp t
	left join @FilteredPowerCurtailmentByEquipement p on p.Equipment = t.Equipment and p.DownTimeType = 'AEP Maintenance'
	
	
	update t
		set t.PJM = p.[Message]
	from @temp t
	left join @FilteredPowerCurtailmentByEquipement p on p.Equipment = t.Equipment and p.DownTimeType = 'PJM'


	update t
		set t.PJMMaintenance = p.[Message]
	from @temp t
	left join @FilteredPowerCurtailmentByEquipement p on p.Equipment = t.Equipment and p.DownTimeType = 'PJM Maintenance'

	

	update t
		set t.[Emergency] = p.[Message]
	from @temp t
	left join @FilteredPowerCurtailmentByEquipement p on p.Equipment = t.Equipment and p.DownTimeType = 'Emergency'

	INSERT INTO @dataT	
	select * from @temp


	RETURN
END





























insert into  MES.PowerCurtailment ([Order],[Page], Equipment, DownTimeType, [Message], [Status])
values
 (1, 'Caster 1','Tundish Preheater','PJM','ON','OK')
,(2, 'Caster 1','Turret','PJM','OFF','NO')
,(3, 'Caster 1','Oscillators','PJM','OFF','NO')
,(4, 'Caster 1','W/S','PJM','OFF','NO')
,(5, 'Caster 1','Torches','PJM','OFF','NO')
,(6, 'Caster 1','Runout Table 1','PJM','OFF','NO')
,(7, 'Caster 1','Runout Table 2','PJM','OFF','NO')
,(8, 'Caster 1','Cross transfer','PJM','OFF','NO')
,(9, 'Caster 1','Pusher Hyd','PJM','OFF','NO')
,(10,'Caster 1','Main Hyd','PJM','ON','OK')
,(11,'Caster 1','Exhaust Fans','PJM','OFF','NO')
,(12,'Caster 1','Pulse Jet','PJM','OFF','NO')
,(13,'Caster 1','Water','PJM','MIN PUMP','OK')
,(14,'Caster 1','Caster Cranes','PJM','MIN USE','OK')
,(15,'Caster 1','Ladle Crane','PJM','MIN USE','OK')



,(1, 'Caster 1','Tundish Preheater','PJM Maintenance','OK','OK')
,(2, 'Caster 1','Turret','PJM Maintenance','OK','OK')
,(3, 'Caster 1','Oscillators','PJM Maintenance','OK','OK')
,(4, 'Caster 1','W/S','PJM Maintenance','OK','OK')
,(5, 'Caster 1','Torches','PJM Maintenance','OK','OK')
,(6, 'Caster 1','Runout Table 1','PJM Maintenance','OK','OK')
,(7, 'Caster 1','Runout Table 2','PJM Maintenance','OK','OK')
,(8, 'Caster 1','Cross transfer','PJM Maintenance','OK','OK')
,(9, 'Caster 1','Pusher Hyd','PJM Maintenance','OK','OK')
,(10,'Caster 1','Main Hyd','PJM Maintenance','OK','OK')
,(11,'Caster 1','Exhaust Fans','PJM Maintenance','NOT OK','NO')
,(12,'Caster 1','Pulse Jet','PJM Maintenance','NOT OK','NO')
,(13,'Caster 1','Water','PJM Maintenance','OK','OK')
,(14,'Caster 1','Caster Cranes','PJM Maintenance','OK','OK')
,(15,'Caster 1','Ladle Crane','PJM Maintenance','OK','OK')


,(1, 'Caster 1','Tundish Preheater','AEP','ON','OK')
,(2, 'Caster 1','Turret','AEP','OFF','NO')
,(3, 'Caster 1','Oscillators','AEP','OFF','NO')
,(4, 'Caster 1','W/S','AEP','OFF','NO')
,(5, 'Caster 1','Torches','AEP','OFF','NO')
,(6, 'Caster 1','Runout Table 1','AEP','OFF','NO')
,(7, 'Caster 1','Runout Table 2','AEP','OFF','NO')
,(8, 'Caster 1','Cross transfer','AEP','OFF','NO')
,(9, 'Caster 1','Pusher Hyd','AEP','OFF','NO')
,(10,'Caster 1','Main Hyd','AEP','ON','OK')
,(11,'Caster 1','Exhaust Fans','AEP','OFF','NO')
,(12,'Caster 1','Pulse Jet','AEP','OFF','NO')
,(13,'Caster 1','Water','AEP','OFF','NO')
,(14,'Caster 1','Caster Cranes','AEP','Min Use','NO')
,(15,'Caster 1','Ladle Crane','AEP','Min Use','NO')

,(1, 'Caster 1','Tundish Preheater','AEP Maintenance','OK','OK')
,(2, 'Caster 1','Turret','AEP Maintenance','OK','OK')
,(3, 'Caster 1','Oscillators','AEP Maintenance','OK','OK')
,(4, 'Caster 1','W/S','AEP Maintenance','OK','OK')
,(5, 'Caster 1','Torches','AEP Maintenance','OK','OK')
,(6, 'Caster 1','Runout Table 1','AEP Maintenance','OK','OK')
,(7, 'Caster 1','Runout Table 2','AEP Maintenance','OK','OK')
,(8, 'Caster 1','Cross transfer','AEP Maintenance','OK','OK')
,(9, 'Caster 1','Pusher Hyd','AEP Maintenance','OK','OK')
,(10,'Caster 1','Main Hyd','AEP Maintenance','OK','OK')
,(11,'Caster 1','Exhaust Fans','AEP Maintenance','NOT OK','NO')
,(12,'Caster 1','Pulse Jet','AEP Maintenance','NOT OK','NO')
,(13,'Caster 1','Water','AEP Maintenance','OK','OK')
,(14,'Caster 1','Caster Cranes','AEP Maintenance','OK','OK')
,(15,'Caster 1','Ladle Crane','AEP Maintenance','OK','OK')


,(1, 'Caster 1','Tundish Preheater','Emergency','OFF','NO')
,(2, 'Caster 1','Turret','Emergency','OFF','NO')
,(3, 'Caster 1','Oscillators','Emergency','OFF','NO')
,(4, 'Caster 1','W/S','Emergency','OFF','NO')
,(5, 'Caster 1','Torches','Emergency','OFF','NO')
,(6, 'Caster 1','Runout Table 1','Emergency','OFF','NO')
,(7, 'Caster 1','Runout Table 2','Emergency','OFF','NO')
,(8, 'Caster 1','Cross transfer','Emergency','OFF','NO')
,(9, 'Caster 1','Pusher Hyd','Emergency','OFF','NO')
,(10,'Caster 1','Main Hyd','Emergency','ON','OK')
,(11,'Caster 1','Exhaust Fans','Emergency','OFF','NO')
,(12,'Caster 1','Pulse Jet','Emergency','OFF','NO')
,(13,'Caster 1','Water','Emergency','OFF','NO')
,(14,'Caster 1','Caster Cranes','Emergency','OFF','NO')
,(15,'Caster 1','Ladle Crane','Emergency','OFF','NO')


insert into  MES.PowerCurtailment ([Order],[Page], Equipment, DownTimeType, [Message], [Status])
values

 (1, 'Caster 2','Tundish Preheater'	,'PJM','ON','OK')
,(2, 'Caster 2','Turret','PJM','OFF','NO')
,(3, 'Caster 2','Oscillators','PJM','OFF','NO')
,(4, 'Caster 2','W/S','PJM','OFF','NO')
,(5, 'Caster 2','Torches','PJM','OFF','NO')
,(6, 'Caster 2','Runout Table 1','PJM','OFF','NO')
,(7, 'Caster 2','Runout Table 2','PJM','OFF','NO')
,(8, 'Caster 2','CTM','PJM','OFF','NO')
,(9, 'Caster 2','Tagging Machines','PJM','OFF','NO')
,(10,'Caster 2','Main Hyd','PJM','ON','OK')
,(11,'Caster 2','Exhaust Fans','PJM','OFF','NO')
,(12,'Caster 2','Pulse Jet','PJM','OFF','NO')
,(13,'Caster 2','Water','PJM','MIN PUMP','OK')
,(14,'Caster 2','Caster Cranes','PJM','MIN USE','OK')
,(15,'Caster 2','Ladle Crane','PJM','MIN USE','OK')


,(1, 'Caster 2','Tundish Preheater','PJM Maintenance','OK','OK')
,(2, 'Caster 2','Turret'	,'PJM Maintenance','OK','OK')
,(3, 'Caster 2','Oscillators'	,'PJM Maintenance','OK','OK')
,(4, 'Caster 2','W/S'	,'PJM Maintenance','OK','OK')
,(5, 'Caster 2','Torches'	,'PJM Maintenance','OK','OK')
,(6, 'Caster 2','Runout Table 1'	,'PJM Maintenance','OK','OK')
,(7, 'Caster 2','Runout Table 2'	,'PJM Maintenance','OK','OK')
,(8, 'Caster 2','CTM'	,'PJM Maintenance','OK','OK')
,(9, 'Caster 2','Tagging Machines'	,'PJM Maintenance','OK','OK')
,(10,'Caster 2','Main Hyd'	,'PJM Maintenance','OK','OK')
,(11,'Caster 2','Exhaust Fans'	,'PJM Maintenance','NOT OK','NO')
,(12,'Caster 2','Pulse Jet'	,'PJM Maintenance','NOT OK','NO')
,(13,'Caster 2','Water','PJM Maintenance','OK','OK')
,(14,'Caster 2','Caster Cranes'	,'PJM Maintenance','OK','OK')
,(15,'Caster 2','Ladle Crane'	,'PJM Maintenance','OK','OK')




,(1, 'Caster 2','Tundish Preheater','AEP','ON','OK')
,(2, 'Caster 2','Turret'	,'AEP','OFF','NO')
,(3, 'Caster 2','Oscillators'	,'AEP','OFF','NO')
,(4, 'Caster 2','W/S'	,'AEP','OFF','NO')
,(5, 'Caster 2','Torches'	,'AEP','OFF','NO')
,(6, 'Caster 2','Runout Table 1'	,'AEP','OFF','NO')
,(7, 'Caster 2','Runout Table 2'	,'AEP','OFF','NO')
,(8, 'Caster 2','CTM'	,'AEP','OFF','NO')
,(9, 'Caster 2','Tagging Machines'	,'AEP','OFF','NO')
,(10,'Caster 2','Main Hyd'	,'AEP','ON','OK')
,(11,'Caster 2','Exhaust Fans'	,'AEP','OFF','NO')
,(12,'Caster 2','Pulse Jet'	,'AEP','OFF','NO')
,(13,'Caster 2','Water','AEP','OFF','NO')
,(14,'Caster 2','Caster Cranes'	,'AEP','MIN USE','OK')
,(15,'Caster 2','Ladle Crane'	,'AEP','MIN USE','OK')



,(1, 'Caster 2','Tundish Preheater','AEP Maintenance','OK','OK')
,(2, 'Caster 2','Turret'	,'AEP Maintenance','OK','OK')
,(3, 'Caster 2','Oscillators'	,'AEP Maintenance','OK','OK')
,(4, 'Caster 2','W/S'	,'AEP Maintenance','OK','OK')
,(5, 'Caster 2','Torches'	,'AEP Maintenance','OK','OK')
,(6, 'Caster 2','Runout Table 1'	,'AEP Maintenance','OK','OK')
,(7, 'Caster 2','Runout Table 2'	,'AEP Maintenance','OK','OK')
,(8, 'Caster 2','CTM'	,'AEP Maintenance','OK','OK')
,(9, 'Caster 2','Tagging Machines'	,'AEP Maintenance','OK','OK')
,(10,'Caster 2','Main Hyd'	,'AEP Maintenance','OK','OK')
,(11,'Caster 2','Exhaust Fans'	,'AEP Maintenance','NOT OK','NO')
,(12,'Caster 2','Pulse Jet'	,'AEP Maintenance','NOT OK','NO')
,(13,'Caster 2','Water','AEP Maintenance','OK','OK')
,(14,'Caster 2','Caster Cranes'	,'AEP Maintenance','OK','OK')
,(15,'Caster 2','Ladle Crane'	,'AEP Maintenance','OK','OK')



,(1, 'Caster 2','Tundish Preheater','Emergency','OFF','NO')
,(2, 'Caster 2','Turret'	,'Emergency','OFF','NO')
,(3, 'Caster 2','Oscillators'	,'Emergency','OFF','NO')
,(4, 'Caster 2','W/S'	,'Emergency','OFF','NO')
,(5, 'Caster 2','Torches'	,'Emergency','OFF','NO')
,(6, 'Caster 2','Runout Table 1'	,'Emergency','OFF','NO')
,(7, 'Caster 2','Runout Table 2'	,'Emergency','OFF','NO')
,(8, 'Caster 2','CTM'	,'Emergency','OFF','NO')
,(9, 'Caster 2','Tagging Machines'	,'Emergency','OFF','NO')
,(10,'Caster 2','Main Hyd'	,'Emergency','OFF','NO')
,(11,'Caster 2','Exhaust Fans'	,'Emergency','OFF','NO')
,(12,'Caster 2','Pulse Jet'	,'Emergency','OFF','NO')
,(13,'Caster 2','Water','Emergency','OFF','NO')
,(14,'Caster 2','Caster Cranes'	,'Emergency','OFF','NO')
,(15,'Caster 2','Ladle Crane'	,'Emergency','OFF','NO')



insert into  MES.PowerCurtailment ([Order],[Page], Equipment, DownTimeType, [Message], [Status])
values

 (1, 'LMF','Alloy Restock','PJM','OFF','NO')
,(2, 'LMF','Micro Alloy','PJM','OFF','NO')
,(3, 'LMF','Alloy Delivery','PJM','OFF','NO')
,(4, 'LMF','LMF Transformers','PJM','OFF','NO')
,(5, 'LMF','Lab Equipment','PJM','ON','OK')
,(6, 'LMF','Ladle Cars','PJM','OFF','NO')
,(7, 'LMF','Lime Restock Blower','PJM','OFF','NO')
,(8, 'LMF','Main Hyd','PJM','ON','OK')
,(9, 'LMF','Transformer Room Fans','PJM','ON','OK')
,(10,'LMF','Pulse Jet','PJM','OFF','NO')
,(11,'LMF','Water','PJM','MIN PUMP','OK')
,(12,'LMF','Caster Crane','PJM','MIN USE','OK')
,(13,'LMF','Ladle Crane','PJM','MIN USE','OK')
 

,(1, 'LMF','Alloy Restock','PJM Maintenance','OK','OK')
,(2, 'LMF','Micro Alloy','PJM Maintenance','OK','OK')
,(3, 'LMF','Alloy Delivery','PJM Maintenance','OK','OK')
,(4, 'LMF','LMF Transformers','PJM Maintenance','NOT OK','NO')
,(5, 'LMF','Lab Equipment','PJM Maintenance','OK','OK')
,(6, 'LMF','Ladle Cars','PJM Maintenance','OK','OK')
,(7, 'LMF','Lime Restock Blower','PJM Maintenance','OK','OK')
,(8, 'LMF','Main Hyd','PJM Maintenance','OK','OK')
,(9, 'LMF','Transformer Room Fans','PJM Maintenance','OK','OK')
,(10,'LMF','Pulse Jet','PJM Maintenance','NOT OK','NO')
,(11,'LMF','Water','PJM Maintenance','OK','OK')
,(12,'LMF','Caster Crane','PJM Maintenance','OK','OK')
,(13,'LMF','Ladle Crane','PJM Maintenance','OK','OK')



,(1, 'LMF','Alloy Restock','AEP','OFF','NO')
,(2, 'LMF','Micro Alloy','AEP','OFF','NO')
,(3, 'LMF','Alloy Delivery','AEP','OFF','NO')
,(4, 'LMF','LMF Transformers','AEP','OFF','NO')
,(5, 'LMF','Lab Equipment','AEP','ON','OK')
,(6, 'LMF','Ladle Cars','AEP','OFF','NO')
,(7, 'LMF','Lime Restock Blower','AEP','OFF','NO')
,(8, 'LMF','Main Hyd','AEP','ON','OK')
,(9, 'LMF','Transformer Room Fans','AEP','ON','OK')
,(10,'LMF','Pulse Jet','AEP','OFF','NO')
,(11,'LMF','Water','AEP','MIN PUMP','OK')
,(12,'LMF','Caster Crane','AEP','MIN USE','OK')
,(13,'LMF','Ladle Crane','AEP','MIN USE','OK')



,(1, 'LMF','Alloy Restock','AEP Maintenance','OK','OK')
,(2, 'LMF','Micro Alloy','AEP Maintenance','OK','OK')
,(3, 'LMF','Alloy Delivery','AEP Maintenance','OK','OK')
,(4, 'LMF','LMF Transformers','AEP Maintenance','NOT OK','NO')
,(5, 'LMF','Lab Equipment','AEP Maintenance','OK','OK')
,(6, 'LMF','Ladle Cars','AEP Maintenance','OK','OK')
,(7, 'LMF','Lime Restock Blower','AEP Maintenance','OK','OK')
,(8, 'LMF','Main Hyd','AEP Maintenance','OK','OK')
,(9, 'LMF','Transformer Room Fans','AEP Maintenance','OK','OK')
,(10,'LMF','Pulse Jet','AEP Maintenance','NOT OK','NO')
,(11,'LMF','Water','AEP Maintenance','OK','OK')
,(12,'LMF','Caster Crane','AEP Maintenance','OK','OK')
,(13,'LMF','Ladle Crane','AEP Maintenance','OK','OK')




,(1, 'LMF','Alloy Restock','Emergency','OFF','NO')
,(2, 'LMF','Micro Alloy','Emergency','OFF','NO')
,(3, 'LMF','Alloy Delivery','Emergency','OFF','NO')
,(4, 'LMF','LMF Transformers','Emergency','OFF','NO')
,(5, 'LMF','Lab Equipment','Emergency','ON','OK')
,(6, 'LMF','Ladle Cars','Emergency','OFF','NO')
,(7, 'LMF','Lime Restock Blower','Emergency','OFF','NO')
,(8, 'LMF','Main Hyd','Emergency','OFF','NO')
,(9, 'LMF','Transformer Room Fans','Emergency','OFF','NO')
,(10,'LMF','Pulse Jet','Emergency','OFF','NO')
,(11,'LMF','Water','Emergency','OFF','NO')
,(12,'LMF','Caster Crane','Emergency','OFF','NO')
,(13,'LMF','Ladle Crane','Emergency','OFF','NO')





insert into  MES.PowerCurtailment ([Order],[Page], Equipment, DownTimeType, [Message], [Status])
values
 (1, 'VTD-BOILER','Boiler','PJM','ON','OK')
,(2, 'VTD-BOILER','Boiler Water System','PJM','ON','OK')
,(3, 'VTD-BOILER','Hotwell Pumps','PJM','MIN PUMP','OK')
,(4, 'VTD-BOILER','Coldwell Pumps','PJM','MIN PUMP','OK')
,(5, 'VTD-BOILER','Cooling Tower Fans','PJM','ON','OK')
,(6, 'VTD-BOILER','U-tube','PJM','OFF','NO')
,(7, 'VTD-BOILER','Pull down','PJM','OFF','NO')
,(8, 'VTD-BOILER','Roof Movement','PJM','OFF','NO')
,(9, 'VTD-BOILER','Caster Cranes','PJM','MIN USE','OK')
,(10,'VTD-BOILER','Ladle Crane','PJM','MIN USE','OK')




,(1, 'VTD-BOILER','Boiler','PJM Maintenance','OK','OK')
,(2, 'VTD-BOILER','Boiler Water System','PJM Maintenance','OK','OK')
,(3, 'VTD-BOILER','Hotwell Pumps','PJM Maintenance','OK','OK')
,(4, 'VTD-BOILER','Coldwell Pumps','PJM Maintenance','OK','OK')
,(5, 'VTD-BOILER','Cooling Tower Fans','PJM Maintenance','OK','OK')
,(6, 'VTD-BOILER','U-tube','PJM Maintenance','OK','OK')
,(7, 'VTD-BOILER','Pull down','PJM Maintenance','OK','OK')
,(8, 'VTD-BOILER','Roof Movement','PJM Maintenance','OK','OK')
,(9, 'VTD-BOILER','Caster Cranes','PJM Maintenance','OK','OK')
,(10,'VTD-BOILER','Ladle Crane','PJM Maintenance','OK','OK')


,(1, 'VTD-BOILER','Boiler','AEP','ON','OK')
,(2, 'VTD-BOILER','Boiler Water System','AEP','ON','OK')
,(3, 'VTD-BOILER','Hotwell Pumps','AEP','MIN PUMP','OK')
,(4, 'VTD-BOILER','Coldwell Pumps','AEP','MIN PUMP','OK')
,(5, 'VTD-BOILER','Cooling Tower Fans','AEP','ON','OK')
,(6, 'VTD-BOILER','U-tube','AEP','OFF','NO')
,(7, 'VTD-BOILER','Pull down','AEP','OFF','NO')
,(8, 'VTD-BOILER','Roof Movement','AEP','OFF','NO')
,(9, 'VTD-BOILER','Caster Cranes','AEP','MIN USE','OK')
,(10,'VTD-BOILER','Ladle Crane','AEP','MIN USE','OK')



,(1, 'VTD-BOILER','Boiler','AEP Maintenance','OK','OK')
,(2, 'VTD-BOILER','Boiler Water System','AEP Maintenance','OK','OK')
,(3, 'VTD-BOILER','Hotwell Pumps','AEP Maintenance','OK','OK')
,(4, 'VTD-BOILER','Coldwell Pumps','AEP Maintenance','OK','OK')
,(5, 'VTD-BOILER','Cooling Tower Fans','AEP Maintenance','OK','OK')
,(6, 'VTD-BOILER','U-tube','AEP Maintenance','OK','OK')
,(7, 'VTD-BOILER','Pull down','AEP Maintenance','OK','OK')
,(8, 'VTD-BOILER','Roof Movement','AEP Maintenance','OK','OK')
,(9, 'VTD-BOILER','Caster Cranes','AEP Maintenance','OK','OK')
,(10,'VTD-BOILER','Ladle Crane','AEP Maintenance','OK','OK')



,(1, 'VTD-BOILER','Boiler','Emergency','LOW FIRE','NO')
,(2, 'VTD-BOILER','Boiler Water System','Emergency','ON','OK')
,(3, 'VTD-BOILER','Hotwell Pumps','Emergency','OFF','NO')
,(4, 'VTD-BOILER','Coldwell Pumps','Emergency','OFF','NO')
,(5, 'VTD-BOILER','Cooling Tower Fans','Emergency','OFF','NO')
,(6, 'VTD-BOILER','U-tube','Emergency','OFF','NO')
,(7, 'VTD-BOILER','Pull down','Emergency','OFF','NO')
,(8, 'VTD-BOILER','Roof Movement','Emergency','OFF','NO')
,(9, 'VTD-BOILER','Caster Cranes','Emergency','OFF','NO')
,(10,'VTD-BOILER','Ladle Crane','Emergency','OFF','NO')


insert into  MES.PowerCurtailment ([Order],[Page], Equipment, DownTimeType, [Message], [Status])
values

 (1, 'Refractory','Tundish Turner','PJM','OFF','NO')
,(2, 'Refractory','Tundish Dryer','PJM','ON','OK')
,(3, 'Refractory','Ladle Preheaters','PJM','ON','OK')
,(4, 'Refractory','Area Fans','PJM','ON','OK')
,(5, 'Refractory','Ladle Bricking Area','PJM','ON','OK')
,(6, 'Refractory','Caster Crane','PJM','MIN USE','OK') 
,(7, 'Refractory','Ladle Crane','PJM','MIN USE','OK')




,(1,'Refractory','Tundish Turner','PJM Maintenance','OK','OK')
,(2,'Refractory','Tundish Dryer','PJM Maintenance','OK','OK')
,(3,'Refractory','Ladle Preheaters','PJM Maintenance','OK','OK')
,(4,'Refractory','Area Fans','PJM Maintenance','OK','OK')
,(5,'Refractory','Ladle Bricking Area','PJM Maintenance','OK','OK')
,(6,'Refractory','Caster Crane','PJM Maintenance','OK','OK')
,(7,'Refractory','Ladle Crane','PJM Maintenance','OK','OK')

,(1,'Refractory','Tundish Turner','AEP','ON','OK')
,(2,'Refractory','Tundish Dryer','AEP','ON','OK')
,(3,'Refractory','Ladle Preheaters','AEP','ON','OK')
,(4,'Refractory','Area Fans','AEP','ON','OK')
,(5,'Refractory','Ladle Bricking Area','AEP','ON','OK')
,(6,'Refractory','Caster Crane','AEP','MIN USE','OK')
,(7,'Refractory','Ladle Crane','AEP','MIN USE','OK')

,(1,'Refractory','Tundish Turner','AEP Maintenance','OK','OK')
,(2,'Refractory','Tundish Dryer','AEP Maintenance','OK','OK')
,(3,'Refractory','Ladle Preheaters','AEP Maintenance','OK','OK')
,(4,'Refractory','Area Fans','AEP Maintenance','OK','OK')
,(5,'Refractory','Ladle Bricking Area','AEP Maintenance','OK','OK')
,(6,'Refractory','Caster Crane','AEP Maintenance','OK','OK')
,(7,'Refractory','Ladle Crane','AEP Maintenance','OK','OK')


,(1,'Refractory','Tundish Turner','Emergency','OFF','NO')
,(2,'Refractory','Tundish Dryer','Emergency','OFF','NO')
,(3,'Refractory','Ladle Preheaters','Emergency','ON','OK')
,(4,'Refractory','Area Fans','Emergency','OFF','NO')
,(5,'Refractory','Ladle Bricking Area','Emergency','ON','OK')
,(6,'Refractory','Caster Crane','Emergency','OFF','NO')
,(7,'Refractory','Ladle Crane','Emergency','OFF','NO')

