﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" meta:resourcekey="PageResource1" %>

<%@ Import Namespace="System.IO" %>
<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>

<script runat="server">
    //@Override this is suggested by Microsoft, overriding the initialize culture function (that is
    //automatically called by the aspx.
    //Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
    //(English).
    protected override void InitializeCulture()
    {
        HttpCookie lang = Request.Cookies["siteLanguage"];

        String selectedLanguage = (lang != null) ? lang.Value : "en";
        UICulture = selectedLanguage;
        Culture = selectedLanguage;

        Thread.CurrentThread.CurrentCulture = CultureInfo.CreateSpecificCulture(selectedLanguage);
        Thread.CurrentThread.CurrentUICulture = new CultureInfo(selectedLanguage);
        base.InitializeCulture();
    }
</script>

<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).

    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<%--view template starts here (will be appended inside a row-fluid)--%>

<link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/lib/backgrid.css") %>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/extensions/add-row-cell/backgrid-add-row-cell.css") %>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/extensions/button-cell/backgrid-button-cell.css") %>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/extensions/valid-min-max-cell/backgrid-valid-min-max-cell.css") %>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/assets/libs/js/jquery.timepicker/jquery.timepicker.css") %>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/app/custom-screens/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + "/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + ".css")%>" rel="stylesheet" />

{{#if mainView}}
<div class="row-fluid subnavbar fixed-subnavbar">
    <div class="row-fluid form-inline">
        <label class="control-label" for="searchTbx">
            <asp:localize runat="server" meta:resourcekey="process_picker_label" />
        </label>
        <div class="input-prepend input-append">
            <button type="button" id="getPreviousItemBtn" class="btn btn-search-prev" data-bind="disabled: navigating," title="<asp:Localize runat=server meta:resourcekey=previous_process_btn_title />"><i class="fa fa-play fa-rotate-180"></i></button>
            <input type="text" id="searchTbx" style="width:100px;" data-bind="value: trim(search), events: ['change', 'keydown',]" placeholder="<asp:Localize runat=server meta:resourcekey=process_picker_place_holder />" data-select-on-focus/>
            <label class="btn btn-search-show" id="showSearchItemsBtn" for="searchTbx"><i class="fa fa-caret-down"></i></label>
            <button type="button" id="getNextItemBtn" class="btn btn-search-next" data-bind="disabled: navigating," title="<asp:Localize runat=server meta:resourcekey=next_process_btn_title />"><i class="fa fa-play"></i></button>
            <button type="button" class="btn" data-bind="clickSet: 'heatId', clickSetValue: -1, disabled: navigating," title="<asp:Localize runat=server meta:resourcekey=current_process_btn_title />"><i class="fa fa-step-forward"></i></button>
        </div>        
    </div>
</div>
{{/if}}

<div class="row-fluid screen-content">
    <div class="no-data-poster row-fluid text-center animated fadeIn" data-bind="classes: { hide: not(all(userHasAccess, mainView, isLoadingProcess)), }" style="height:500px;">
        <div class="row-fluid" style="position:relative;top:100px;">
            <i class="fa fa-cog fw-icon-4x fa-spin" style="font-size:115px;"></i>
        </div>
        <div class="row-fluid" style="position:relative;top:115px;">
            <h3 style="font-size:50px;">
                <asp:localize runat="server" meta:resourcekey="loading_data" />
            </h3>
        </div>
    </div>
    <div class="row-fluid process-info-container" data-bind="classes: { hide: not(all(userHasAccess, mainView, not(isLoadingProcess))), },">
        <div class="form-horizontal process-info-form process-info-form-1 pull-left">
            <div class="row-fluid">
                <h4 class="heat-number-container pull-left" data-bind="text: format('<asp:Localize runat=server meta:resourcekey=process_info_title /> $1', coalesce(trim(eafProcess_heatName), '<asp:localize runat=server meta:resourcekey=no_value_legend />')),"></h4>
            </div>
            <%--<div class="process-info-row">
                <div class="process-info-group">
                    <span class="process-info-field-label-long-text"><asp:Localize runat=server meta:resourcekey=process_info_initial_grade_label /></span>
                    <select class="process-info-field-value" style="width:140px;" data-bind="value: integer(process_initialGradeId), options: select(process_id, grades, []), optionsEmpty: { label: '<asp:localize runat=server meta:resourcekey=grades_combo_empty_opt />', value: 0 }, enabled: all(process_id, hasGrades), classes: { hide: not(editionEnabled), },"></select>
                    <span class="process-info-field-value" data-bind="text: coalesce(trim(process_initialGradeName), '<asp:localize runat=server meta:resourcekey=no_value_legend />'), classes: { hide: not(not(editionEnabled)), },"></span>
                </div>
            </div>--%>
        </div>
    </div>
    <div class="row-fluid" data-bind="classes: { hide: not(all(userHasAccess, not(isLoadingProcess))), }," style="margin-top:10px;">
        <h5 class="grid-title"><asp:Localize runat=server meta:resourcekey=samples_title /></h5>
        <%--<i class="fa fa-lock manual-lock-btn" data-bind="classes: { hide: not(contains({ name: 'CHEMISTRY-SAMPLES', }, process_manualVariables)), },"></i>--%>
        <div class="samples-grid-container"></div>
    </div>
</div>

<script id="actions_header_cell_template" type="text/x-handlebars-template">
    <button data-toggle="tooltip" data-placement="bottom" data-cell-action="NEW" title="<asp:Localize runat=server meta:resourcekey=grid_new_btn_title />" class="btn btn-cell-action btn-small btn-new"><i class="fa fa-plus"></i></button>
</script>

<script id="actions_cell_template" type="text/x-handlebars-template">
    <button data-toggle="tooltip" data-placement="bottom" data-cell-action="SAVE" title="<asp:Localize runat=server meta:resourcekey=grid_save_btn_title />" class="btn btn-small btn-cell-action btn-save hide" style="margin-right:2px;"><i class="fa fa-floppy-o"></i></button>
    <button data-toggle="tooltip" data-placement="bottom" data-cell-action="DISCARD" title="<asp:Localize runat=server meta:resourcekey=grid_discard_btn_title />" class="btn btn-small btn-cell-action btn-discard hide"><i class="fa fa-times"></i></button>
    <button data-toggle="tooltip" data-placement="bottom" data-cell-action="DELETE" title="<asp:Localize runat=server meta:resourcekey=grid_remove_btn_title />" class="btn btn-small btn-cell-action btn-remove"><i class="fa fa-trash-o"></i></button>
    <button data-toggle="tooltip" data-placement="bottom" data-cell-action="MOVE" title="<asp:Localize runat=server meta:resourcekey=grid_move_btn_title />" class="btn btn-small btn-cell-action btn-remove"><i class="fa fa-arrow-circle-right"></i></button>
</script>

<script id="heat_edit_modal_template" type="text/x-handlebars-template">
    <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
        <h3><asp:Localize runat="server" meta:resourcekey="heat_edit_modal_title" /></h3>
    </div>
    <div style="max-height:500px;" class="modal-body">
        <div class="row-fluid">
            <div class="form-horizontal">
                 <div class="control-group">
                    <%--<label class="control-label">
                        <asp:localize runat="server" meta:resourcekey="heat_edit_modal_actual_heat_label" />
                    </label>--%>
                    <%--<div class="controls">
                        <span class="static-control" data-bind="text: coalesce(heatName, '-'),"></span>
                    </div>--%>
                </div>
                <%--<div class="control-group">
                    <label class="control-label">
                        <asp:localize runat="server" meta:resourcekey="heat_edit_modal_heat_label" />
                    </label>
                    <div class="controls">
                        <select class="input-large autofocus" data-bind="value: integer(heatId), options: heats, optionsDefault: { label: '<asp:localize runat=server meta:resourcekey=heat_combo_choose_opt />', value: 0 }, enabled: true,"></select>
                    </div>
                </div> --%>
                <div class="input-prepend input-append">
                    <button type="button" id="getPreviousItemBtn" class="btn btn-search-prev" data-bind="disabled: navigating," title="<asp:Localize runat=server meta:resourcekey=previous_process_btn_title />"><i class="fa fa-play fa-rotate-180"></i></button>
            <input type="text" id="searchTbx" style="width:100px;" data-bind="value: trim(search), events: ['change', 'keydown',]" placeholder="<asp:Localize runat=server meta:resourcekey=process_picker_place_holder />" data-select-on-focus/>
            <label class="btn btn-search-show" id="showSearchItemsBtn" for="searchTbx"><i class="fa fa-caret-down"></i></label>
            <button type="button" id="getNextItemBtn" class="btn btn-search-next" data-bind="disabled: navigating," title="<asp:Localize runat=server meta:resourcekey=next_process_btn_title />"><i class="fa fa-play"></i></button>
            <button type="button" class="btn" data-bind="clickSet: 'heatId', clickSetValue: -1, disabled: navigating," title="<asp:Localize runat=server meta:resourcekey=current_process_btn_title />"><i class="fa fa-step-forward"></i></button>
                </div>
            </div>
        </div>
    </div>
    <div class="modal-footer">
        <div class="modal-status-msg-container pull-left">
            <div class="modal-status-msg hide" data-bind="toggle: processing,">
                <asp:Localize runat='server' meta:resourcekey='heat_edit_modal_processing_msg' />
                <i class="fa fa-cog fa-spin"></i>
            </div>
        </div>
        <button id="acceptBtn" data-bind="enabled: all(notEquals(processing, true))," class="btn btn-primary">
            <asp:Localize runat='server' meta:resourcekey='heat_edit_modal_accept_btn_label' />
        </button>
        <button data-bind="enabled: notEquals(processing, true)" class="btn" data-dismiss="modal">
            <asp:Localize runat='server' meta:resourcekey='heat_edit_modal_cancel_btn_label' />
        </button>
    </div>
</script>