﻿define([
  'app',
  'modules/catalog',
],
function (app, Catalog) {

    var Main = {
        Models: {},
        Collections: {},
    };

    (function () {
        var superRef, superProto, classRef;

        superRef = Catalog.Models.Catalog;
        superProto = superRef.prototype;

        Main.Models.EventMode = classRef = superRef.extend({
            defaults: _.extend(
                {},
                superProto.defaults,
                {
                    modeId: null,
                    modeName: null,
                    eventTypeId: null,
                    counterType: null
                }
            ),
            procedures: {
                get: app.DatabaseNames.ELT + '.SYSTEM.GetModesPerEvent',
            },

            parse: function (obj) {
                return _.extend(superProto.parse.apply(this, arguments), {
                    modeId: obj.ModeId,
                    modeName: obj.ModeName,
                    eventTypeId: obj.EventTypeId,
                    counterType: obj.CounterType
                });
            },
        });
    })();

    (function () {
        var superRef, superProto, classRef;

        superRef = Catalog.Collections.Catalogs;
        superProto = superRef.prototype;

        Main.Collections.EventModes = classRef = superRef.extend({
            model: Main.Models.EventMode,
        });
        _.extend(classRef, {
            fetch: function (options) {
                var opt = _.extend(
                        { error: function () { }, success: function () { }, },
                        options
                    );

                classRef.prototype.getData.apply(classRef.prototype, [_.extend(
                    {},
                    opt,
                    {
                        success: function (resp) {
                            if (resp.Table) {
                                opt.success(_.map(resp.Table, classRef.prototype.model.prototype.parse));
                            }
                            else {
                                var msg = (resp.Message) ? resp.Message : 'Can not fetch event mode.';

                                console.error(new Error(msg).stack);
                                opt.error(msg);
                            }
                        },
                    }
                )]);
            },
        });
    })();

    // Required, return the module for AMD compliance.
    return Main;

});