﻿define([
  'app',
  'modules/base/base',
],
function (app, Base) {

    var Main = {
        Models: {},
        Collections: {},
    };

    (function () {
        var superRef, superProto, classRef;

        superRef = Base.Models.Base;
        superProto = superRef.prototype;

        Main.Models.ProcessHeating = classRef = superRef.extend({
            defaults: _.extend(
                {},
                superProto.defaults,
                {
                    id: null,

                    processId: null,

                    tap: null,
                    end: null,
                    energy: null,
                    start: null,
                }
            ),

            parse: function (obj) {
                return {
                    id: obj.Id,

                    processId: obj.ProcessId,

                    tap: obj.Tap,
                    end: obj.EndString,
                    energy: obj.Energy,
                    start: obj.StartString,
                };
            },
        });
    })();

    (function () {
        var superRef, superProto, classRef;

        superRef = Base.Collections.Base;
        superProto = superRef.prototype;

        Main.Collections.ProcessHeatings = classRef = superRef.extend({
            model: Main.Models.ProcessHeating,
            comparator: 'start',
        });
    })();

    // Required, return the module for AMD compliance.
    return Main;

});