﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" meta:resourcekey="PageResource1" %>

<%@ Import Namespace="System.IO" %>
<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>

<script runat="server">
    String version = WebAppVersion.GetWebAppVersion();

    //@Override this is suggested by Microsoft, overriding the initialize culture function (that is
    //automatically called by the aspx.
    //Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
    //(English).
    protected override void InitializeCulture()
    {
        HttpCookie lang = Request.Cookies["siteLanguage"];

        String selectedLanguage = (lang != null) ? lang.Value : "en";
        UICulture = selectedLanguage;
        Culture = selectedLanguage;

        Thread.CurrentThread.CurrentCulture = CultureInfo.CreateSpecificCulture(selectedLanguage);
        Thread.CurrentThread.CurrentUICulture = new CultureInfo(selectedLanguage);
        base.InitializeCulture();
    }
</script>

<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).

    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<%--view template starts here (will be appended inside a row-fluid)--%>


<script id="delays_report" type="text/x-handlebars-template">

    <link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/lib/backgrid.css")%>" rel="stylesheet" />
    <link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/extensions/valid-limit-cell/backgrid-valid-limit-cell.css") %>" rel="stylesheet" />
    <link href="<%= ResolveUrl("~/app/pages/caster/caster-delays-manager/caster-delays-manager.css")%>" rel="stylesheet" />
    <link href="<%= ResolveUrl("~/assets/libs/js/jquery.contextMenu/jquery.contextMenu.css") %>" rel="stylesheet" />
    
    <link href="<%= ResolveUrl("~/assets/ag-grid/ag-grid.css") %>" rel="stylesheet" />
    <link href="<%= ResolveUrl("~/assets/ag-grid/ag-theme-alpine.css") %>" rel="stylesheet" />
    <link href="<%= ResolveUrl("~/assets/fonts/reboto-font.css") %>" rel="stylesheet" />
    <link href="<%= ResolveUrl("~/assets/tailwind/tailwind.min.css") %>" rel="stylesheet" />

<style>

     /* Reduced grid container height */
     .processes-grid-container.ag-theme-alpine {
        height: 70vh; /* Reduced height */
        border: 1px solid #ccc;
    }
    .ag-root-wrapper.ag-layout-normal.ag-ltr {
        height: 70vh;
    }
    
 .processes-grid-container .ag-pinned-right-cols-container,
    .processes-grid-container .ag-pinned-left-cols-container {
      border-right: none !important;
    } 
    
    .ag-cell.ag-cell-last-left-pinned:not(.ag-cell-range-right):not(.ag-cell-range-single-cell) {
        border-right: none !important;
    }

    .ag-pinned-left-header {
    border-right: none !important;
}

    /* Undeclared delay row styling */
    .ag-theme-alpine .ag-row.undeclared-delay-row,
    .processes-grid-container .ag-row.undeclared-delay-row {
        background-color: #D0A4A4 !important;
    }
    
    .processes-grid-container .ag-row.undeclared-delay-row .ag-cell {
        background-color: #D0A4A4 !important;
    }
    
 /* Page content */
 .content-container{
            padding-top: 0px !important;
        }
        #subnavbar-inner{
            display:none !important;
        }
        /*Page Title */
       .professional-title {
            font-size: 22px;
            font-weight: 400;
            color: #202124;
            padding-bottom: 1px;
            border-bottom: 1px solid #dadce0;
            margin-bottom: 2px;
            font-family: 'Roboto', Arial, sans-serif;
        }
        /*date picker*/
        .date-picker{
            border:none !important;
            margin-bottom: 0px !important;
            -webkit-box-shadow:none !important;
            box-shadow: none !important;
            width: 100px;
            text-align: center;
        }
        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
        .spinner {
            animation: spin 1s linear infinite;
            transform-origin: center;
        }

        @keyframes downloadAnimation {
            0% { transform: translateY(-1px); }
            50% { transform: translateY(1px); }
            100% { transform: translateY(-1px); }
        }
        .document {
            animation: downloadAnimation 1s ease-in-out infinite;
        }

</style>

<h2 class="professional-title">Caster Delays Manager</h2>

<div class="bg-white shadow-md rounded-lg p-2 mb-4">  
    <div data-bind="classes: { hide: isPageLoading }">
        <div class="bg-white shadow-md rounded-lg mb-2">
            <div class="flex items-center justify-between">
                <div class="flex items-center space-x-2 mb-2">         
                    <div class="flex flex-wrap items-center space-x-1">
                        <div class="flex flex-col">
                            <div class="flex items-center">
                                <label for="dateTbx" class="ml-2 mr-2 text-sm font-medium text-gray-700">Start</label>
                                <div class="flex items-center border border-gray-300 rounded-md">
                                    <input type="text" id="dateStartTbx" class="input-date date-picker pl-10 pr-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-1 focus:ring-blue-500 focus:border-blue-500" style="z-index:1000;width:100px" data-bind="value: momentFormat(start$, 'YYYY-MM-DD', '<asp:Localize runat=server meta:resourcekey=mmddyyyy_format />')">
                                    <button id="calendarStartBtn" class="px-2 py-2 border-l border-gray-300 hover:bg-gray-100">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-gray-600" viewBox="0 0 20 20" fill="currentColor">
                                            <path fill-rule="evenodd" d="M6 2a1 1 0 00-1 1v1H4a2 2 0 00-2 2v10a2 2 0 002 2h12a2 2 0 002-2V6a2 2 0 00-2-2h-1V3a1 1 0 10-2 0v1H7V3a1 1 0 00-1-1zm0 5a1 1 0 000 2h8a1 1 0 100-2H6z" clip-rule="evenodd" />
                                        </svg>
                                    </button>
                                </div>
                            </div>
                        </div>


                        <div class="flex flex-col"></div>
                            <div class="flex items-center">
                                <label for="dateTbx" class="ml-2 mr-2 text-sm font-medium text-gray-700">End</label>
                                <div class="flex items-center border border-gray-300 rounded-md">
                                    <input type="text" id="dateEndTbx" class="input-date date-picker pl-10 pr-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-1 focus:ring-blue-500 focus:border-blue-500" style="z-index:1000;width:100px" data-bind="value: momentFormat(end$, 'YYYY-MM-DD', '<asp:Localize runat=server meta:resourcekey=mmddyyyy_format />')">
                                    <button id="calendarEndBtn" class="px-2 py-2 border-l border-gray-300 hover:bg-gray-100">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-gray-600" viewBox="0 0 20 20" fill="currentColor">
                                            <path fill-rule="evenodd" d="M6 2a1 1 0 00-1 1v1H4a2 2 0 00-2 2v10a2 2 0 002 2h12a2 2 0 002-2V6a2 2 0 00-2-2h-1V3a1 1 0 10-2 0v1H7V3a1 1 0 00-1-1zm0 5a1 1 0 000 2h8a1 1 0 100-2H6z" clip-rule="evenodd" />
                                        </svg>
                                    </button>
                                </div>
                            </div>
                    </div> 
                    <div class="flex flex-wrap items-center space-x-1">
                     
                         <div class="flex items-center">
                            <label class="ml-2 mr-2 text-sm font-medium text-gray-700">Caster</label>
                            <select disabled data-bind="value: casterId, options: casters,optionsDefault: { label: 'All', value: '-' }" class="block w-full pl-3 pr-10 text-base border-gray-300 focus:outline-none focus:ring-blue-500 focus:border-blue-500 sm:text-sm rounded-md print-drop-down">
                            </select>
                        </div>
                        <!--<div class="flex items-center">
                            <label class="ml-2 mr-2 text-sm font-medium text-gray-700">Crew</label>
                            <select disabled data-bind="value: crewId, options: crews,optionsDefault: { label: 'All', value: '-' }" class="block w-full pl-3 pr-10 py-2 text-base border-gray-300 focus:outline-none focus:ring-blue-500 focus:border-blue-500 sm:text-sm rounded-md print-drop-down">
                            </select>
                        </div> -->
                        <div class="flex items-center">
                            <label class="flex items-center cursor-pointer">
                                <input type="checkbox" id="showOnlyUndeclaredToggle" data-bind="checked: showOnlyUndeclared" class="w-4 h-4 text-blue-600 bg-gray-100 border-gray-300 rounded focus:ring-blue-500 focus:ring-2" style="margin-left: 16px;">
                                <span class="ml-2 text-sm font-medium text-gray-700">Show only undeclared delays</span>
                            </label>
                        </div>
                        
                        
                    </div>
                </div>
                <div class="flex space-x-2 mb-2">
                    <button id="refreshBtn" class="bg-blue-600 hover:bg-blue-700 text-white py-2 px-4 rounded flex items-center justify-center" style="width: 250px; height: 36.5px; font-size: 14px;">
                        <div data-bind="classes: { hide: isLoading }">
                            <span>Refresh</span>
                        </div>
                        <div data-bind="classes: { hide: not(isLoading) }">
                            <div class="flex items-center">
                                <svg class="h-5 w-5 mr-3" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                                    <g class="spinner">
                                        <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4" fill="none"/>
                                        <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"/>
                                    </g>
                                </svg>
                                <span>Loading...</span>
                            </div>
                            
                        </div>
                    </button>

                </div>
            </div>   
                    
        </div>   
        <div class="mx-auto">       
            <div class="bg-white shadow-md rounded-lg p-2 mb-4" style="border: 4px solid #ccc;">
                <div class="processes-grid-container ag-theme-alpine w-full"></div>
            </div>
            <div class="mt-4 flex justify-end">
                <button class="new_delay_btn hover:bg-blue-700 text-white py-2 px-4 rounded" style="background-color: #3F51B5; width: 250px; height: 36.5px;">
                    NEW DELAY
                </button>
            </div>
        </div>
    </div>   
    
    <div data-bind="classes: { hide: not(isPageLoading) }">
        <div class="bg-white shadow-md rounded-lg mb-2">
            <div class="flex items-center justify-between">
                <div class="flex items-center space-x-2 mb-2">
                    <div class="flex flex-wrap items-center space-x-1">
                        <div class="skeleton-input w-40 h-10 bg-gray-200 rounded-md"></div>
                        <div class="skeleton-input w-40 h-10 bg-gray-200 rounded-md"></div>
                    </div>
                    <div class="skeleton-select w-32 h-10 bg-gray-200 rounded-md"></div>
                </div>
                <div class="flex space-x-2 mb-2">
                    <div class="skeleton-button w-64 h-9 bg-gray-200 rounded"></div>
                </div>
            </div>
        </div>
        <div class="mx-auto">
            <div class="bg-white shadow-md rounded-lg p-2 mb-4" style="border: 4px solid #ccc;">
                <div class="skeleton-grid w-full h-64vh bg-gray-200"></div>
            </div>
        </div>
    </div>
</div>
</script>

<!-- SPLIT MODAL -->
<script id="delay_split_split_action_template"  type="text/x-handlebars-template">
    <link href="<%= ResolveUrl("~/assets/libs/js/bootstrap-slider/css/bootstrap-slider.min.css") %>" rel="stylesheet" />
    <link href="<%= ResolveUrl("~/assets/ag-grid/ag-theme-alpine.css") %>" rel="stylesheet" />
    <link href="<%= ResolveUrl("~/assets/fonts/reboto-font.css") %>" rel="stylesheet" />
    <link href="<%= ResolveUrl("~/assets/tailwind/tailwind.min.css") %>" rel="stylesheet" />
    <link href="<%= ResolveUrl("~/app/pages/caster/caster-delays-manager/caster-delays-manager.css")%>" rel="stylesheet" />
    <style>
        #split_delay_slider .slider-selection {
	        background: #479dc4;
        }

        /*#split_delay_slider .slider-track-low {
            background: #479dc4;
        }*/
        
        #split_delay_slider .slider-track-high {
            background: #00ff90;
        }

        #split_delay_slider .slider-handle {
	        border-bottom-color: blue;
        }

        .tooltip-main.tooltip > .tooltip-inner {background-color: #e8e8e8;color:#000;}
        .tooltip-main.tooltip > .tooltip-arrow {border-bottom-color:#e8e8e8 !important; border-top-color:#e8e8e8 !important}

        .gray-tooltip.tooltip > .tooltip-inner {background-color: #b6b6b6;color:#000;}
        .gray-tooltip.tooltip > .tooltip-arrow {border-bottom-color:#b6b6b6 !important}

        .slider .top.tooltip {
            margin-top:-43px;
        }

        #caster-delays-manager-split {
            width: 800px !important;
            margin-left: -400px !important;
        }

        

    </style>
    <div class="modal-header noselect">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
        <h3 class="text-lg font-semibold text-gray-800 mb-4">Split Delay</h3>
    </div>
    <div style="max-height:600px;" class="modal-body noselect">
        <div class="row-fluid text-center">
            <span class="muted"><asp:Localize runat="server" meta:resourcekey="drag_to_change_duration_label" /></span>
        </div>
        <div class="row-fluid">
            <div class="pull-left" style="margin-left:10px;">
                <span style="font-size:10px;margin-left:2px;">{{start_date}}</span><br />
                <span style="font-size:14px;">{{start_time}}</span>
            </div>
            <div class="pull-right" style="margin-right:10px;">
                <span style="font-size:10px;margin-left:2px;">{{end_date}}</span><br />
                <span style="font-size:14px;">{{end_time}}</span>
            </div>
        </div>
        <div style="height:50px;" class="row-fluid">
            <div class="span12">
                <div class="span10" style="margin:0 auto;position:relative;float:none;clear:both;">
                    <div class="span12 slider-container" style="display:inline-block;">
                        <div class="slider-arrow-left" style="display:inline-block;width:5%;text-align:right;top:1px;position:relative;">
                            <i style="cursor:pointer;" class="fa fa-arrow-left"></i>
                        </div>
                        <input type="text" class="slider" style="width:90%;display:inline-block;" value="" 
                            data-slider-id="split_delay_slider" 
                            id="split_delay_slider_original" data-slider-tooltip="hover" />
                        <div class="slider-arrow-right" style="display:inline-block;text-align:left;top:1px;position:relative;width:3%;">
                            <i style="cursor:pointer;" class="fa fa-arrow-right"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="grid grid-cols-2">
            <!-- Delay 1 -->
            <div class="delay1 pr-6">
              <h3 class="text-lg font-semibold text-gray-800 mb-4">Delay 1</h3>
              <div class="space-y-4">
                <div class="flex justify-between">
                <div>
                    <label class="w-20 text-sm font-medium text-gray-700">Caster</label>
                    <input disabled type="text" id="caster-code" style="height: 40px; text-align:center; width: 70%" data-bind="value:casterCode" class="w-full px-3 py-2 border border-gray-300 rounded-md text-sm focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500" placeholder="CasterCode">
                </div>
                 <div >
                  <label class="w-20 text-sm font-medium text-gray-700">Start</label>
                  <input disabled type="text" id="delay1-start" style="height: 40px; text-align:center; width: 90%" data-bind="value:delay1Start" class="w-full px-3 py-2 border border-gray-300 rounded-md text-sm focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500" placeholder="Start">
                </div>
                <div>
                    <label class="w-20 text-sm font-medium text-gray-700">End</label>
                    <input disabled type="text" id="delay1-end" style="height: 40px; text-align:center; width: 90%" data-bind="value:delay1End" class="w-full px-3 py-2 border border-gray-300 rounded-md text-sm focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500" placeholder="End">
                
                </div>
                </div>
                <div class="flex space-x-4">
                    <div class="flex flex-col w-1/2">
                        <label class="text-sm font-medium text-gray-700 mb-1">Category</label>
                        <select style="height:40px"
                            class="w-full text-center py-2 border border-gray-300 rounded-md text-sm focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500" 
                            id="delay1-category" 
                            data-bind="value: integer(delayCategoryId1), options: delayCategories">
                        </select>
                    </div>
                
                    <div class="flex flex-col w-1/2">
                        <label class="text-sm font-medium text-gray-700 mb-1">Code</label>
                        <select style="height:40px"
                            class="w-full text-center px-3 py-2 border border-gray-300 rounded-md text-sm focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500" 
                            id="delay1-code" 
                            data-bind="value: integer(delayCodeId1), options: delayCodes1">
                        </select>
                    </div>
                </div>
                
                <div class="flex flex-col">
                    <label class="text-sm font-medium text-gray-700 mb-1">Comments</label>
                    <textarea id="delay1-comments" class="w-full px-3 py-2 border border-gray-300 rounded-md text-sm focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500" rows="2" placeholder="0/200 max." data-bind="value: commentsDelay1"></textarea>
                </div>
                
              </div>
            </div>
            <!-- Delay 2 -->
            <div class="delay2 border-l border-gray-300 pl-6">
              <h3 class="text-lg font-semibold text-gray-800 mb-4">Delay 2</h3>
              <div class="space-y-4">
                <div class="flex justify-between">
                    <div>
                        <label class="w-20 text-sm font-medium text-gray-700">Caster</label>
                        <input disabled type="text" id="caster-code" style="height: 40px; text-align:center; width: 70%" data-bind="value:casterCode" class="w-full px-3 py-2 border border-gray-300 rounded-md text-sm focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500" placeholder="CasterCode">
                    </div>
                    <div>
                        <label class="w-20 text-sm font-medium text-gray-700">Start</label>
                        <input disabled type="text" id="delay2-start"  style="height: 40px; text-align:center; width: 90%" data-bind="value:delay2Start" class="w-full px-3 py-2 border border-gray-300 rounded-md text-sm focus:outline-none focus:ring-2 focus:ring-green-500 focus:border-green-500" placeholder="09:52:22">
                    
                    </div>
                    <div >
                        <label class="w-20 text-sm font-medium text-gray-700">End</label>
                        <input disabled type="text" id="delay2-end"  style="height: 40px; text-align:center; width: 90%" data-bind="value:delay2End" class="w-full px-3 py-2 border border-gray-300 rounded-md text-sm focus:outline-none focus:ring-2 focus:ring-green-500 focus:border-green-500" placeholder="11:07:57">
                      </div>
                    
                   </div>
               
                
                    
                
                   <div class="flex space-x-4">
                    <div class="flex flex-col w-1/2">
                        <label class="text-sm font-medium text-gray-700 mb-1">Category</label>
                        <select style="height:40px"
                        class="w-full text-center py-2 border border-gray-300 rounded-md text-sm focus:outline-none focus:ring-2 focus:ring-green-500 focus:border-green-500" id="delay1-category" data-bind="value: integer(delayCategoryId2), options: delayCategories">
                         
                        </select>
                    </div>
                
                    <div class="flex flex-col w-1/2">
                        <label class="text-sm font-medium text-gray-700 mb-1">Code</label>
                        <select style="height:40px"
                        class="w-full text-center px-3 py-2 border border-gray-300 rounded-md text-sm focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500" id="delay1-code" data-bind="value: integer(delayCodeId2), options: delayCodes2">
                      
                        </select>
                    </div>
                </div>
                
                <div class="flex flex-col">
                  <label class="w-20 text-sm font-medium text-gray-700">Comments</label>
                  <textarea id="delay2-comments" class="w-full px-3 py-2 border border-gray-300 rounded-md text-sm focus:outline-none focus:ring-2 focus:ring-green-500 focus:border-green-500" rows="2" placeholder="0/200 max." data-bind="value: commentsDelay2"></textarea>
                </div>
              </div>
            </div>
          </div>
    </div>
    <div class="modal-footer noselect">
        <div class="flex w-full space-x-4">
            <!-- Split Button -->
            <button id="delay_split_modal_split_btn" 
                    class="delay_split_modal_split_btn w-1/2 bg-blue-600 hover:bg-blue-700 text-white py-2 px-4 rounded h-10">
                SPLIT
            </button>
    
            <!-- Cancel Button -->
            <button id="delay_split_modal_cancel_btn" 
                    class="btn-close w-1/2 bg-gray-100 hover:bg-gray-200 rounded border border-gray-300 h-10">
                CANCEL
            </button>
        </div>
    </div>
    
</script>

<!-- JUSTIFY MODAL -->
<script id="justify_delay" type="text/x-handlebars-template">
    <link href="<%= ResolveUrl("~/assets/ag-grid/ag-theme-alpine.css") %>" rel="stylesheet" />
    <link href="<%= ResolveUrl("~/assets/fonts/reboto-font.css") %>" rel="stylesheet" />
    <link href="<%= ResolveUrl("~/assets/tailwind/tailwind.min.css") %>" rel="stylesheet" />
    <style>
            #caster-delays-manager-create {
            width: 650px !important;
        }
    </style>
    <div class="modal-header noselect">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
        <h3 class="text-lg font-semibold text-gray-800 mb-4">Justify Delay</h3>
    </div>
    <div style="max-height:450px;" class="modal-body noselect">
        <div class="delay1">
            <div class="space-y-4">
                <div class="flex space-x-4">
                    <div class="flex flex-col items-start w-1/3">
                        <label class="text-sm font-medium text-gray-700 mb-1">Start</label>
                        <input style="height:40px" disabled type="text" id="delay1-start" data-bind="value:start" class=" text-center w-full px-3 py-2 border border-gray-300 rounded-md text-sm focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                    </div>
                
                    <div class="flex flex-col items-start w-1/3">
                        <label class="text-sm font-medium text-gray-700 mb-1">End</label>
                        <input style="height:40px" disabled type="text" id="delay1-end" data-bind="value:end" class="text-center w-full px-3 py-2 border border-gray-300 rounded-md text-sm focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                    </div>
                
                    <div class="flex flex-col items-start w-1/3">
                        <label class="text-sm font-medium text-gray-700 mb-1">Duration</label>
                        <input style="height:40px" disabled type="text" id="delay1-duration" data-bind="value:durationinMin" class=" text-center w-full px-3 py-2 border border-gray-300 rounded-md text-sm focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                    </div>
                </div>
                
              <div class="flex space-x-4">
                <div class="flex flex-col w-1/4">
                    <label class="text-sm font-medium text-gray-700 mb-1">Caster</label>
                    <input style="height:40px" disabled type="text" id="caster-number" data-bind="value:casterCode" class="text-center w-full px-3 py-2 border border-gray-300 rounded-md text-sm focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
            
                </div>
                <div class="flex flex-col w-1/2">
                    <label class="text-sm font-medium text-gray-700 mb-1">Category</label>
                    <select style="height:40px"
                    class="w-full text-center py-2 border border-gray-300 rounded-md text-sm focus:outline-none focus:ring-2 focus:ring-green-500 focus:border-green-500" id="delay1-category" data-bind="value: integer(delayCategoryId), options: delayCategories">
                     
                    </select>
                </div>
            
                <div class="flex flex-col w-1/2">
                    <label class="text-sm font-medium text-gray-700 mb-1">Code</label>
                    <select style="height:40px"
                    class="w-full text-center px-3 py-2 border border-gray-300 rounded-md text-sm focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500" id="delay1-code" data-bind="value: integer(delayCodeId), options: delayCodes1">
                  
                    </select>
                </div>
            </div>
            <div class="flex flex-col">
                <label class="w-20 text-sm font-medium text-gray-700">Comments</label>
                <textarea id="delay2-comments" class="w-full px-3 py-2 border border-gray-300 rounded-md text-sm focus:outline-none focus:ring-2 focus:ring-green-500 focus:border-green-500" rows="4" placeholder="0/200 max." data-bind="value: commentsDelay"></textarea>
              </div>
            </div>
          </div>
    </div>
    <div class="modal-footer noselect">
        <div class="row-fluid">
            <div class="flex items-center justify-between">
                <div class="span6">
                    <button id="delay_justify_btn" class="bg-blue-600 hover:bg-blue-700 text-white py-2 px-4 rounded" style="width: 250px; height: 36.5px;">JUSTIFY</button>
                </div>
                <button id="delay_justify_cancel_btn" class="btn-close bg-gray-100 hover:bg-gray-200 rounded " style="width: 250px; height: 36.5px; border: 1px solid">CANCEL</button>
            </div>
        </div>
    </div>
</script>

<!-- NEW DELAY MODAL -->
<script id="new_delay" type="text/x-handlebars-template">
    <link href="<%= ResolveUrl("~/assets/ag-grid/ag-theme-alpine.css") %>" rel="stylesheet" />
    <link href="<%= ResolveUrl("~/assets/fonts/reboto-font.css") %>" rel="stylesheet" />
    <link href="<%= ResolveUrl("~/assets/tailwind/tailwind.min.css") %>" rel="stylesheet" /
    <div class="modal-header noselect">
        <button type="button" class="close mr-2" data-dismiss="modal" aria-hidden="true">&times;</button>
        <h3 class="text-lg font-semibold text-gray-800 mb-4  mt-4 ml-4">New Delay</h3>
    </div>
    <div style="max-height:450px;" class="modal-body noselect">
        <div class="delay1">
            <div class="space-y-4">
                <div class="flex space-x-4">
                    <div class="flex flex-col items-start w-1/3">
                        <label class="text-sm font-medium text-gray-700 mb-1">Start</label>
                        <input style="height:40px" type="datetime-local" id="delay1-start" data-bind="value:start" class=" text-center w-full px-3 py-2 border border-gray-300 rounded-md text-sm focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                    </div>
                
                    <div class="flex flex-col items-start w-1/3">
                        <label class="text-sm font-medium text-gray-700 mb-1">End</label>
                        <input style="height:40px" type="datetime-local" id="delay1-end" data-bind="value:end" class="text-center w-full px-3 py-2 border border-gray-300 rounded-md text-sm focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                    </div>
                
                    <div class="flex flex-col items-start w-1/3">
                        <label class="text-sm font-medium text-gray-700 mb-1">Duration</label>
                        <input style="height:40px" disabled type="text" id="delay1-duration" data-bind="value:durationinMin" class=" text-center w-full px-3 py-2 border border-gray-300 rounded-md text-sm focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                    </div>
                </div>
                
                <div class="flex space-x-4">
                    <div class="flex flex-col w-1/4">
                        <label class="text-sm font-medium text-gray-700 mb-1">Caster</label>
                        <select style="height:40px"  id="caster-number" data-bind="value: integer(casterCode), options: casterCodes" class="text-center w-full px-3 py-2 border border-gray-300 rounded-md text-sm focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                        </select>
                    </div>
                    <div class="flex flex-col w-1/2">
                        <label class="text-sm font-medium text-gray-700 mb-1">Category</label>
                        <select style="height:40px"
                        class="w-full text-center py-2 border border-gray-300 rounded-md text-sm focus:outline-none focus:ring-2 focus:ring-green-500 focus:border-green-500" id="delay1-category" data-bind="value: integer(delayCategoryId), options: delayCategories">
                         
                        </select>
                    </div>
                
                    <div class="flex flex-col w-1/2">
                        <label class="text-sm font-medium text-gray-700 mb-1">Code</label>
                        <select style="height:40px"
                        class="w-full text-center px-3 py-2 border border-gray-300 rounded-md text-sm focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500" id="delay1-code" data-bind="value: integer(delayCodeId), options: delayCodes">
                      
                        </select>
                    </div>
                </div>
            <div class="flex flex-col">
                <label class="w-20 text-sm font-medium text-gray-700">Comments</label>
                <textarea id="delay2-comments" class="w-full px-3 py-2 border border-gray-300 rounded-md text-sm focus:outline-none focus:ring-2 focus:ring-green-500 focus:border-green-500" rows="4" placeholder="0/200 max." data-bind="value: commentsDelay"></textarea>
              </div>
            </div>
          </div>
    </div>
    <div class="modal-footer noselect">
        <div class="row-fluid">
            <div class="flex items-center justify-between">
                <div class="span6">
                    <button id="new_delay_accept_btn" class="bg-blue-600 hover:bg-blue-700 text-white py-2 px-4 rounded" style="width: 250px; height: 36.5px;">CREATE DELAY</button>
                </div>
                <button id="new_delay_cancel_btn" class="btn-close bg-gray-100 hover:bg-gray-200 rounded " style="width: 250px; height: 36.5px; border: 1px solid">CANCEL</button>
            </div>
        </div>
    </div>
</script>
  