﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" meta:resourcekey="PageResource1" %>

<%@ Import Namespace="System.IO" %>
<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>

<script runat="server">
    String version = WebAppVersion.GetWebAppVersion();

    //@Override this is suggested by Microsoft, overriding the initialize culture function (that is
    //automatically called by the aspx.
    //Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
    //(English).
    protected override void InitializeCulture()
    {
        HttpCookie lang = Request.Cookies["siteLanguage"];

        String selectedLanguage = (lang != null) ? lang.Value : "en";
        UICulture = selectedLanguage;
        Culture = selectedLanguage;

        Thread.CurrentThread.CurrentCulture = CultureInfo.CreateSpecificCulture(selectedLanguage);
        Thread.CurrentThread.CurrentUICulture = new CultureInfo(selectedLanguage);
        base.InitializeCulture();
    }
</script>

<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).

    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<%--view template starts here (will be appended inside a row-fluid)--%>

<link href="<%= ResolveUrl("~/assets/ag-grid/ag-grid.css") %>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/assets/ag-grid/ag-theme-alpine.css") %>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/assets/fonts/reboto-font.css") %>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/assets/tailwind/tailwind.min.css") %>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/assets/libs/js/multiselect/virtual-select.min.css") %>" rel="stylesheet" />


<style>
    /* Page content */
    .content-container{
        padding-top: 0px !important;
    }
    #subnavbar-inner{
        display:none !important;
    }
    /*Page Title */
    .professional-title {
        font-size: 22px;
        font-weight: 400;
        color: #202124;
        padding-bottom: 1px;
        border-bottom: 1px solid #dadce0;
        margin-bottom: 2px;
        font-family: 'Roboto', Arial, sans-serif;
    }

    .professional-subtitle {
        font-size: 18px;
        font-weight: 400;
        color: #202124;
        padding-bottom: 1px;
        margin-bottom: 2px;
        font-family: 'Roboto', Arial, sans-serif;
       
    }
    /*date picker*/
    .date-picker{
        border:none !important;
        margin-bottom: 0px !important;
        -webkit-box-shadow:none !important;
        box-shadow: none !important;
        width: 100px;
        text-align: center;
    }
    .print-drop-down{
        width: 60px;
        height: 37.78px;
        padding: 0px !important;
        text-align: center;
    }
    @keyframes spin {
        0% { transform: rotate(0deg); }
        100% { transform: rotate(360deg); }
    }
    .spinner {
        animation: spin 1s linear infinite;
        transform-origin: center;
    }

    @keyframes downloadAnimation {
        0% { transform: translateY(-1px); }
        50% { transform: translateY(1px); }
        100% { transform: translateY(-1px); }
    }
    .document {
        animation: downloadAnimation 1s ease-in-out infinite;
    }

    /* right side of the screen */
    @keyframes blink {
        0%, 100% { opacity: 1; }
        50% { opacity: 0.5; }
    }
    .blink {
        animation: blink 2s linear infinite;
    }
    .real-time-title {
        font-size: 22px;
        font-weight: 400;
        color: #202124;
        margin-left: 5px;
        padding-bottom: 1px;
        margin-bottom: 2px;
        font-family: 'Roboto', Arial, sans-serif;
    }
    .pickers-section{
        height: 45px !important;
    }
    .h-screen-custom{
        height: 80vh;
    }
    /* Border for the first child column of each cover */
.ag-cell.cover-first-column {
    border-left: 2px solid #ddd;  /* Left border to separate the first column */
}

/* Border for the last child column of each cover */
.ag-cell.cover-last-column {
    border-right: 2px solid #ddd;  /* Right border to separate the last column */
}

/* Center the parent headers (group headers) */
.ag-header-group-cell-label {
    display: flex;
    justify-content: center; /* Centers horizontally */
    align-items: center;     /* Centers vertically */
    text-align: center;
    width: 100%;             /* Ensure the label takes full width */
}

/* Center the child headers (individual columns) */
.ag-header-cell-label {
    display: flex;
    justify-content: center; /* Centers horizontally */
    align-items: center;     /* Centers vertically */
    text-align: center;
    width: 100%;             /* Ensure the label takes full width */
}


/* .ag-theme-alpine{
    height: 70vh !important;
} */
.vscomp-toggle-button {
    border-radius: 4px !important;
    height: 45px !important;
}
.vscomp-toggle-button{
    display: flex;
    align-content: center;
    justify-content:  space-around;
    align-items: center;
}

.hide{
    display: none;
}
</style>



<h2 class="professional-title" data-bind="text:screenTitle">
</h2>

<div class="relative flex items-center justify-center">
    <div class="bg-white shadow-md rounded-lg mb-1 pickers-section w-screen relative">
        <div class="flex items-center space-x-3 mb-1">
            <h3 class="professional-subtitle ml-2">
                Heat
            </h3>
            <div id="heat-picker-multi-select" style="width:200px;"></div>
        </div>  
        
        <div class="flex space-x-2 mb-1">
            <!-- Button -->
            <button 
                id="assignBtn" 
                class="absolute top-0 right-0 bg-green-600 hover:bg-green-700 text-white py-2 px-4 rounded flex items-center justify-center mb-1 mr-2"
                style="width: 250px; height: 44x; font-size: 16px;"
            >
                Assign Melt Order or Grade
            </button>
        </div>
    </div>
</div>  
 

<div class="flex h-screen-custom" data-bind="classes: { hide: not(renderCompleted) }">  
  
    <div class="w-full bg-white shadow-md p-0">    
        <div class="mx-auto">       
            <div class="bg-white shadow-md rounded-lg p-2 mb-4" style="border: 4px solid #ccc;height: 78vh;">
                <div class="grid-container-products-from-sdi w-full" style="height: 70vh;border:1px solid #ccc"></div>
            </div>    
            <div class="mt-4 flex justify-end">
            </div>
        </div>
    </div>

 
</div>
