<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" meta:resourcekey="PageResource1" %>

<%@ Import Namespace="System.IO" %>
<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>

<script runat="server">
    String version = WebAppVersion.GetWebAppVersion();

    //@Override this is suggested by Microsoft, overriding the initialize culture function (that is
    //automatically called by the aspx.
    //Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
    //(English).
    protected override void InitializeCulture()
    {
        HttpCookie lang = Request.Cookies["siteLanguage"];

        String selectedLanguage = (lang != null) ? lang.Value : "en";
        UICulture = selectedLanguage;
        Culture = selectedLanguage;

        Thread.CurrentThread.CurrentCulture = CultureInfo.CreateSpecificCulture(selectedLanguage);
        Thread.CurrentThread.CurrentUICulture = new CultureInfo(selectedLanguage);
        base.InitializeCulture();
    }
</script>

<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).

    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<%--view template starts here (will be appended inside a row-fluid)--%>

<link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/lib/backgrid.css")%>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/app/pages/opcua/opcua-browser/opcua-browser.css")%>" rel="stylesheet" />

<link href="<%= ResolveUrl("~/assets/ag-grid/ag-grid.css") %>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/assets/ag-grid/ag-theme-alpine.css") %>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/assets/fonts/reboto-font.css") %>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/assets/tailwind/tailwind.min.css") %>" rel="stylesheet" />


<style>

 /* Page content */
 .content-container{
            padding-top: 0px !important;
        }
        #subnavbar-inner{
            display:none !important;
        }
        /*Page Title */
       .professional-title {
            font-size: 22px;
            font-weight: 400;
            color: #202124;
            padding-bottom: 1px;
            border-bottom: 1px solid #dadce0;
            margin-bottom: 2px;
            font-family: 'Roboto', Arial, sans-serif;
        }
        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
        .spinner {
            animation: spin 1s linear infinite;
            transform-origin: center;
        }

        /* Tree view styles */
        .opcua-tree {
            border: 1px solid #ccc;
            border-radius: 4px;
            background: white;
            overflow-y: auto;
        }
        .tree-node {
            padding: 4px 8px;
            cursor: pointer;
            user-select: none;
        }
        .tree-node:hover {
            background-color: #f0f0f0;
        }
        .tree-node.selected {
            background-color: #e3f2fd;
        }
        .tree-node.has-children {
            font-weight: 500;
        }
        .tree-node.variable {
            color: #1976d2;
        }
        .tree-expand-icon {
            display: inline-block;
            width: 16px;
            text-align: center;
            margin-right: 4px;
        }
        .tree-loading {
            color: #999;
            font-style: italic;
            padding-left: 24px;
        }

        /* Real-time panel styles */
        .realtime-panel-header {
            background-color: #f5f5f5;
            padding: 8px 12px;
            border-bottom: 1px solid #ddd;
            font-weight: 600;
        }

</style>



<h2 class="professional-title">OPC UA Browser</h2>

<div class="bg-white shadow-md rounded-lg p-2 mb-4">  
    <div data-bind="classes: { hide: isPageLoading }">
        <div class="flex flex-row gap-4" style="height: calc(100vh - 140px);">
            <!-- Left Panel: Tree View -->
            <div class="flex flex-col w-2/5" style="height: 100%;">
                <div class="realtime-panel-header" style="flex-shrink: 0;">
                    <span>Tag Tree</span>
                </div>
                <!-- Search Input -->
                <div class="tree-search-container" style="flex-shrink: 0; padding: 10px 8px; border-bottom: 1px solid #ddd; background: #fafafa;">
                    <div class="tree-search-wrapper" style="position: relative; height: 44px;">
                        <i class="fa fa-search" style="position: absolute; left: 14px; top: 50%; transform: translateY(-50%); color: #888; font-size: 16px; pointer-events: none;"></i>
                        <input type="text"
                               id="tree-search-input"
                               class="tree-search-input"
                               placeholder="Search tags..."
                               autocomplete="off"
                               style="width: 100%; height: 44px; padding: 0 42px; border: 1px solid #ddd; border-radius: 4px; font-size: 14px; outline: none; box-sizing: border-box;" />
                        <button type="button" id="tree-search-clear" class="tree-search-clear" style="display: none; position: absolute; right: 10px; top: 50%; transform: translateY(-50%); background: none; border: none; color: #888; cursor: pointer; padding: 6px 10px; font-size: 16px;">
                            <i class="fa fa-times"></i>
                        </button>
                    </div>
                </div>
                <div id="opcua-tree-container" class="opcua-tree flex-1" style="overflow-y: auto; min-height: 0;">
                    <div data-bind="classes: { hide: not(isTreeLoading) }" class="tree-loading">
                        Loading root nodes...
                    </div>
                    <div id="tree-content"></div>
                </div>
            </div>

            <!-- Right Panel: Real-Time Monitoring -->
            <div class="flex flex-col w-3/5" style="height: 100%;">
                <div class="realtime-panel-header" style="flex-shrink: 0;">
                    <span>Real-Time Panel</span>
                    <span class="text-sm text-gray-600" data-bind="text: selectedTagsCountText"></span>
                </div>
                <!-- Tag Groups Toolbar -->
                <div class="groups-toolbar" style="flex-shrink: 0;">
                    <div class="groups-toolbar-inner">
                        <label class="groups-label">Groups:</label>
                        <select id="groups-dropdown" class="groups-dropdown">
                            <option value="">-- Select a group --</option>
                        </select>
                        <button type="button" id="btn-load-group" class="groups-btn groups-btn-primary" title="Load selected group">
                            <i class="fa fa-download"></i> Load
                        </button>
                        <button type="button" id="btn-save-group" class="groups-btn groups-btn-success" title="Save current tags as a new group">
                            <i class="fa fa-save"></i> Save As
                        </button>
                        <button type="button" id="btn-manage-groups" class="groups-btn groups-btn-secondary" title="Manage groups">
                            <i class="fa fa-cog"></i> Manage
                        </button>
                        <div class="groups-separator"></div>
                        <label class="groups-label predefined-label"><i class="fa fa-star"></i> Predefined:</label>
                        <select id="predefined-groups-dropdown" class="groups-dropdown predefined-dropdown">
                            <option value="">-- View predefined --</option>
                        </select>
                        <button type="button" id="btn-clone-predefined" class="groups-btn groups-btn-info" title="Clone selected predefined group" disabled>
                            <i class="fa fa-clone"></i> Clone
                        </button>
                    </div>
                </div>
                <div class="realtime-grid-container ag-theme-alpine flex-1" style="border:1px solid #ccc; min-height: 0; overflow: hidden;"></div>
            </div>

            <!-- Save Group Modal -->
            <div id="save-group-modal" class="groups-modal" style="display: none;">
                <div class="groups-modal-overlay"></div>
                <div class="groups-modal-content">
                    <div class="groups-modal-header">
                        <h3>Save Tags as Group</h3>
                        <button type="button" class="groups-modal-close" data-dismiss="modal">&times;</button>
                    </div>
                    <div class="groups-modal-body">
                        <div class="form-group">
                            <label for="save-group-name">Group Name <span class="required">*</span></label>
                            <input type="text" id="save-group-name" class="form-input" placeholder="Enter group name" maxlength="100" />
                        </div>
                        <div class="form-group">
                            <label for="save-group-description">Description</label>
                            <textarea id="save-group-description" class="form-input" placeholder="Optional description" maxlength="500" rows="3"></textarea>
                        </div>
                        <div class="form-group">
                            <label>Tags to save: <span id="save-group-tag-count" class="tag-count-badge">0</span></label>
                        </div>
                    </div>
                    <div class="groups-modal-footer">
                        <button type="button" class="groups-btn groups-btn-secondary" data-dismiss="modal">Cancel</button>
                        <button type="button" id="btn-save-group-confirm" class="groups-btn groups-btn-success">Save Group</button>
                    </div>
                </div>
            </div>

            <!-- Manage Groups Modal -->
            <div id="manage-groups-modal" class="groups-modal" style="display: none;">
                <div class="groups-modal-overlay"></div>
                <div class="groups-modal-content groups-modal-large">
                    <div class="groups-modal-header">
                        <h3>Manage Tag Groups</h3>
                        <button type="button" class="groups-modal-close" data-dismiss="modal">&times;</button>
                    </div>
                    <div class="groups-modal-body">
                        <div id="manage-groups-list" class="groups-list">
                            <!-- Groups will be rendered here -->
                        </div>
                        <div id="manage-groups-empty" class="groups-empty" style="display: none;">
                            <i class="fa fa-folder-open-o"></i>
                            <p>No groups found. Save your current tags to create a group.</p>
                        </div>
                    </div>
                    <div class="groups-modal-footer">
                        <button type="button" class="groups-btn groups-btn-secondary" data-dismiss="modal">Close</button>
                    </div>
                </div>
            </div>

            <!-- Edit Group Modal -->
            <div id="edit-group-modal" class="groups-modal" style="display: none;">
                <div class="groups-modal-overlay"></div>
                <div class="groups-modal-content">
                    <div class="groups-modal-header">
                        <h3>Edit Group</h3>
                        <button type="button" class="groups-modal-close" data-dismiss="modal">&times;</button>
                    </div>
                    <div class="groups-modal-body">
                        <input type="hidden" id="edit-group-id" />
                        <div class="form-group">
                            <label for="edit-group-name">Group Name <span class="required">*</span></label>
                            <input type="text" id="edit-group-name" class="form-input" placeholder="Enter group name" maxlength="100" />
                        </div>
                        <div class="form-group">
                            <label for="edit-group-description">Description</label>
                            <textarea id="edit-group-description" class="form-input" placeholder="Optional description" maxlength="500" rows="3"></textarea>
                        </div>
                    </div>
                    <div class="groups-modal-footer">
                        <button type="button" class="groups-btn groups-btn-secondary" data-dismiss="modal">Cancel</button>
                        <button type="button" id="btn-edit-group-confirm" class="groups-btn groups-btn-primary">Update Group</button>
                    </div>
                </div>
            </div>

            <!-- Context Menu: Add Tag to Existing Group Modal -->
            <div id="ctx-group-select-modal" class="groups-modal" style="display: none;">
                <div class="groups-modal-overlay"></div>
                <div class="groups-modal-content">
                    <div class="groups-modal-header">
                        <h3>Add Tag to Group</h3>
                        <button type="button" class="groups-modal-close" data-dismiss="modal">&times;</button>
                    </div>
                    <div class="groups-modal-body">
                        <p>Tag: <strong id="ctx-select-tag-name"></strong></p>
                        <div class="form-group">
                            <label for="ctx-group-dropdown">Select Group</label>
                            <select id="ctx-group-dropdown" class="form-input">
                                <option value="">-- Select a group --</option>
                            </select>
                        </div>
                    </div>
                    <div class="groups-modal-footer">
                        <button type="button" class="groups-btn groups-btn-secondary" data-dismiss="modal">Cancel</button>
                        <button type="button" id="btn-ctx-add-to-group-confirm" class="groups-btn groups-btn-primary">Add to Group</button>
                    </div>
                </div>
            </div>

            <!-- Context Menu: Create New Group & Add Tag Modal -->
            <div id="ctx-new-group-modal" class="groups-modal" style="display: none;">
                <div class="groups-modal-overlay"></div>
                <div class="groups-modal-content">
                    <div class="groups-modal-header">
                        <h3>Create New Group &amp; Add Tag</h3>
                        <button type="button" class="groups-modal-close" data-dismiss="modal">&times;</button>
                    </div>
                    <div class="groups-modal-body">
                        <p>Tag: <strong id="ctx-new-tag-name"></strong></p>
                        <div class="form-group">
                            <label for="ctx-new-group-name">Group Name <span class="required">*</span></label>
                            <input type="text" id="ctx-new-group-name" class="form-input" placeholder="Enter group name" maxlength="100" />
                        </div>
                        <div class="form-group">
                            <label for="ctx-new-group-description">Description</label>
                            <textarea id="ctx-new-group-description" class="form-input" placeholder="Optional description" maxlength="500" rows="3"></textarea>
                        </div>
                    </div>
                    <div class="groups-modal-footer">
                        <button type="button" class="groups-btn groups-btn-secondary" data-dismiss="modal">Cancel</button>
                        <button type="button" id="btn-ctx-new-group-confirm" class="groups-btn groups-btn-success">Create &amp; Add</button>
                    </div>
                </div>
            </div>

            <!-- Load Group Options Modal -->
            <div id="load-group-modal" class="groups-modal" style="display: none;">
                <div class="groups-modal-overlay"></div>
                <div class="groups-modal-content">
                    <div class="groups-modal-header">
                        <h3>Load Group</h3>
                        <button type="button" class="groups-modal-close" data-dismiss="modal">&times;</button>
                    </div>
                    <div class="groups-modal-body">
                        <p>How would you like to load the group "<span id="load-group-name"></span>"?</p>
                        <div class="load-options">
                            <label class="load-option">
                                <input type="radio" name="load-mode" value="replace" checked />
                                <span class="load-option-text">
                                    <strong>Replace</strong>
                                    <small>Clear current tags and load group tags</small>
                                </span>
                            </label>
                            <label class="load-option">
                                <input type="radio" name="load-mode" value="merge" />
                                <span class="load-option-text">
                                    <strong>Merge</strong>
                                    <small>Add group tags to current tags (skip duplicates)</small>
                                </span>
                            </label>
                        </div>
                    </div>
                    <div class="groups-modal-footer">
                        <button type="button" class="groups-btn groups-btn-secondary" data-dismiss="modal">Cancel</button>
                        <button type="button" id="btn-load-group-confirm" class="groups-btn groups-btn-primary">Load Group</button>
                    </div>
                </div>
            </div>
        </div>
    </div>   
    
    <div data-bind="classes: { hide: not(isPageLoading) }">
        <div class="mx-auto">
            <div class="bg-white shadow-md rounded-lg p-2 mb-4" style="border: 4px solid #ccc;">
                <div class="skeleton-grid w-full h-64vh bg-gray-200"></div>
            </div>
        </div>
    </div>

</div>
