-------------
-- ROLES
-------------
	USE [IHBoxSystem]
	GO
	CREATE ROLE wtrs_read AUTHORIZATION dbo 
	GO  

	USE [IHBoxSystem]
	GO
	EXEC sp_addrolemember 'wtrs_read', 'admin'
	GO

	USE [IHBoxSystem]
	GO
	EXEC sp_addrolemember 'wtrs_read', 'SDI/australtek'
	GO



-------------------
-- Menu and Route
-------------------
	declare @parent int, @result_routeId INT
	-- Try to find existing "Reports" or "Weather" menu, otherwise use root
	select @parent=id from [FrontEnd].[Menu] where [Name] = 'Reports' and Parent is null
	if @parent is null
		select @parent=id from [FrontEnd].[Menu] where [Name] = 'Weather' and Parent is null
	if @parent is null
		select @parent=id from [FrontEnd].[Menu] where Parent is null and [Name] = 'MES' -- fallback to MES section
    -- If no parent found, set to NULL for root level
    if @parent is null
        set @parent = null

	INSERT INTO [FrontEnd].[Routes]
			   ([Route]
			   ,[ModuleName]
			   ,[ModulePath]
			   ,[RequiredRole]
		   )
		 VALUES 
			   (
			   '!/weather-tracking-summary(/:start)(/:end)(/:heatName)(/)'
			   , 'weather-tracking-summary'
			   , 'pages/weather-tracking-summary/'
			   , 'wtrs_read'           
			   )
			   SET @result_routeId = @@IDENTITY
	INSERT INTO [FrontEnd].[Menu]
			   ([Parent]
			   ,[Name]
			   ,[RouteID]
			   ,[SortOrder]
			   ,[Enabled]
			   ,[Visible]
			   ,[RequiredRole]
			   ,[Group]
			  )
		 VALUES
			   (
			   @parent
			   ,'Weather Tracking Summary'
			   ,@result_routeId 
			   ,2
			   ,1
			   ,1
			   ,'wtrs_read'
			   ,NULL
			 )
	GO


-------------------
-- SP Permissions
-------------------
EXECUTE sys.sp_addextendedproperty 
@level0type = N'USER' -- The object type
,@level0name = [wtrs_read] -- The role
,@name = N'securedsp-MES.MES.GetWeatherTrackingSummary' -- the procedure
,@value = N'' 
GO


-------------------
--	Profiles
-------------------
	USE [IHBoxSystem]
	GO

	DECLARE @ModuleId INT

	INSERT INTO [SECURITY].[Modules]([Code],[Name])
	VALUES('wtrs_read','Weather Tracking Summary')

	SET @ModuleId = @@IDENTITY


	INSERT INTO [SECURITY].ModuleActions(ModuleId,Code,[Name],[Role])
	VALUES (@ModuleId,'read','Read','wtrs_read')





