define(['jquery'], function (jQuery) {

!function($){

    "use strict";

    //-----------------------------
    //Class definition
    //-----------------------------

    var SelectOnFocus = function (element, options) {
        $(element).bind('focus', element_focus);
    };

    function element_focus (e) {
        //var $this = $(this)
        //$this.on('focus', focus);
        //selectText(this);
        $(this)[0].select();
        //e.preventDefault();
        //e.stopPropagation();
    };


    //-----------------------------
    //Jquery plugin definition
    //-----------------------------

    var old = $.fn.selectonfocus;

    $.fn.selectonfocus = function (option) {
        return this.each(function () {
            var $this = $(this)
              , data = $this.data('selectonfocus')
              , options = typeof option == 'object' && option;
            if (!data) $this.data('selectonfocus', (data = new SelectOnFocus(this, options)));
            if (typeof option == 'string') data[option]();
        });
    };

    $.fn.selectonfocus.Constructor = SelectOnFocus;


    //-----------------------------
    //No conflict
    //-----------------------------
    $.fn.selectonfocus.noConflict = function () {
        $.fn.selectonfocus = old;
        return this;
    };

    //-----------------------------
    //Data Api
    //-----------------------------
    //Only attach data api if was not attached before.
    if (old == null)
        $(document).on('focus.select-on-focus.data-api', '[data-select-on-focus]', element_focus);

}(jQuery);

});