﻿<%@ Page Language="C#" MasterPageFile="~/landing/landing_base.master"  AutoEventWireup="true" CodeFile="initConfig.aspx.cs" Inherits="landing_initConfig" culture="auto" meta:resourcekey="PageResource1" uiculture="auto" %>

<script runat="server">
    String version = WebAppVersion.GetWebAppVersion(); 
</script>

<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>
<script runat="server">
    string siteLang = "EN";
    protected override void InitializeCulture()
    {
        HttpCookie lang = Request.Cookies["siteLanguage"];

        siteLang = (lang != null) ? lang.Value : siteLang;
        UICulture = siteLang;
        Culture = siteLang;

        Thread.CurrentThread.CurrentCulture =
            CultureInfo.CreateSpecificCulture(siteLang);
        Thread.CurrentThread.CurrentUICulture = new
            CultureInfo(siteLang);
        base.InitializeCulture();
    }
</script>
<asp:Content ID="head" ContentPlaceHolderID="content_head" runat="Server">

    <!--working with local copies -->
    
    <% bool debug = true; %>

    <!-- industrial dashboard css & js -->
    <script src="<%
        
        if (debug == true){
            Response.Write(ResolveUrl(VirtualPathUtility.GetDirectory(Request.ApplicationPath) + "IndustrialDashboard/Scripts/IndustrialDashboard-debug.js?v=" + version)); 
        } else {
            Response.Write(ResolveUrl(VirtualPathUtility.GetDirectory(Request.ApplicationPath) + "IndustrialDashboard/Scripts/IndustrialDashboard.js?v=" + version)); 
        }
        
        %>" type="text/javascript"></script> 

    <link type="text/css" href="<%= ResolveUrl(VirtualPathUtility.GetDirectory(Request.ApplicationPath) + "IndustrialDashboard/Styles/IndustrialDashboard.css?v=" + version) %>" rel="stylesheet" />

    <!--bootstrap-->
    <link href="<%= ResolveUrl("~/assets/bootstrap/css/custom-bootstrap.min.css") %>" rel="stylesheet" />
    <%--<link href="<%= ResolveUrl("~/assets/bootstrap-3.2.0/css/bootstrap.min.css") %>" rel="stylesheet" />--%>
    <link href="<%= ResolveUrl("~/assets/css/font-awesome/css/font-awesome.css") %>" rel="stylesheet" />
    <link href="<%= ResolveUrl("~/assets/css/font-awesome-4.2.0/css/font-awesome.css") %>" rel="stylesheet" />
    <link href="<%= ResolveUrl("~/assets/css/font-awesome-animation-0.0.7/css/font-awesome-animation.css") %>" rel="stylesheet" />

    <style>
        body {
            background:#FFF !important; 
        }
    </style>

    <link href="<%= ResolveUrl("~/assets/bootstrap/css/bootstrap-responsive.css") %>" rel="stylesheet" />
    <link href="<%= ResolveUrl("~/assets/css/jquery-ui/jquery-ui-1.10.3.custom.css") %>" rel="stylesheet" />
    <link href="<%= ResolveUrl("~/assets/libs/js/bootstrap-timepicker/css/bootstrap-timepicker.css") %>" rel="stylesheet" />
    <link href="<%= ResolveUrl("~/assets/css/index-ui.css?v=" + version) %>" rel="stylesheet" />    

    <link href="<%= ResolveUrl("~/assets/css/open-sans/open-sans.css") %>" rel="stylesheet" />    

    <style type="text/css">
        @media (max-width: 979px) {
            body {
                padding-top: 53px;
            }
        }
    </style>

    <%--<link rel="stylesheet" href="http://fonts.googleapis.com/css?family=Raleway:600,400,500,300,100,700" type="text/css">--%>
    <link href="<%= ResolveUrl("~/assets/css/index-ui-template.css?v=" + version) %>" rel="stylesheet" />
    <link href="<%= ResolveUrl("~/assets/css/animate.css") %>" rel="stylesheet" />

    <script src="<%= ResolveUrl("~/assets/libs/jam/jquery/dist/jquery.js") %>"></script>
    <script src="<%= ResolveUrl("~/assets/libs/js/jquery-ui-1.10.3.js") %>"></script>

    <!-- nprogress bar for ajax loading feedback -->
<%--    <link href="<%= ResolveUrl("~/assets/libs/js/nprogress/nprogress.css") %>" rel="stylesheet" />
    <script src="<%= ResolveUrl("~/assets/libs/js/nprogress/nprogress.js") %>"></script>--%>

    <script>
        <%    
            string locale_data = i18n.GetJedLocaleData(siteLang);
            Response.Write("var jed_locale_data =" + locale_data + ";"); 
        %>
    </script>

    <script type="text/javascript">
        var _Includer = new window.Includer({
            XML: { Available: false },
            Theme: "ABGPortal",
        });
    </script>

</asp:Content>
<asp:Content ID="body" ContentPlaceHolderID="content_body" runat="Server">

    <%    
        SystemInitialConfigurationStatus currentInitConfStatus = IhBoxSystemtConfiguration.InitialConfigurationStatus; 
    %>

    <script src="<%= ResolveUrl("~/assets/libs/js/require.js") %>"></script>
    <%--<script src="<%= ResolveUrl("initConfig.js") %>"></script>--%>

    <div id="top_messages_bar_container">
        <!--here goes the top messages bar -->
    </div>

    <style>
        .config-view-panel {
            float:left;
            margin-top:10px;
            height:auto;
            margin-right:2.5%
            /*border-right:2px solid #D5D5D5;*/
        }
        .config-view-panel:last-child {
            margin-right:0;
        }

        .footer-container {
            margin-top:0;
        }

        .big-wrapper .btn-primary {
            color: #ffffff;
            background-color: #479dc4;
            border-color: #ffffff;
            border-width: 5px;
            background-image: none;
        }
        .big-wrapper .btn-primary:hover,
        .big-wrapper .btn-primary:focus,
        .big-wrapper .btn-primary.focus,
        .big-wrapper .btn-primary:active,
        .big-wrapper .btn-primary.active,
        .open > .big-wrapper .dropdown-toggle.btn-primary {
            color: #479dc4;
            background-color: #ffffff;
            border-color: #ffffff;
        }
        .big-wrapper .btn-primary:active,
        .big-wrapper .btn-primary.active,
        .open > .dropdown-toggle.big-wrapper .btn-primary {
            background-image: none;
        }
        .big-wrapper .btn-primary.disabled,
        .big-wrapper .btn-primary[disabled],
        fieldset[disabled] .big-wrapper .btn-primary,
        .big-wrapper .btn-primary.disabled:hover,
        .big-wrapper .btn-primary[disabled]:hover,
        fieldset[disabled] .big-wrapper .btn-primary:hover,
        .big-wrapper .btn-primary.disabled:focus,
        .big-wrapper .btn-primary[disabled]:focus,
        fieldset[disabled] .big-wrapper .btn-primary:focus,
        .big-wrapper .btn-primary.disabled.focus,
        .big-wrapper .btn-primary[disabled].focus,
        fieldset[disabled] .big-wrapper .btn-primary.focus,
        .big-wrapper .btn-primary.disabled:active,
        .big-wrapper .btn-primary[disabled]:active,
        fieldset[disabled] .big-wrapper .btn-primary:active,
        .big-wrapper .btn-primary.disabled.active,
        .big-wrapper .btn-primary[disabled].active,
        fieldset[disabled] .big-wrapper .btn-primary.active {
            background-color: #479dc4;
            border-color: #ffffff;
        }
        .big-wrapper .btn-primary[disabled]:hover {
            color: #479dc4;
            background-color: #ffffff;
        }
        .big-wrapper .btn-primary .badge {
            color: #479dc4;
            background-color: #ffffff;
        }

        .loading-big-wrapper p{
        }

        .poster-font {
            color: #FFFFFF;
            font-family: 'Segoe UI Light', 'Open Sans';
            font-size: 2rem;
            font-weight: 300; 
            line-height: 1;
        }
       
        li.validation-list-item {
            margin-top:5px;
            display: inline-block;
        }
        li.validation-list-item.not-valid {
            cursor:help;
        }

        li.validation-list-item i {
            vertical-align: middle;
            font-size:25px;
        }
        i[name="valid"] {
            color:#48B848;
        } 
        i[name="notValid"] {
            color:#E83C3C;
        } 
        .not-valid i[name="valid"] { 
            display:none;
        }
        .valid i[name="notValid"] { 
            display:none;
        }

        #main {
            padding-bottom:0;
        }
        #tz-footer-wrapper-container {
            display:none;
        }

        .big-poster-align-center {
            text-align:center;
        }

        .big-font-poster {
            font-size:3rem !important; 
        }

        .big-poster-btn{
            font-family: 'Segoe UI Light', 'Open Sans', Arial, sans-serif;
            display: block;
            color: rgb(255, 255, 255);
            text-decoration: none;
            text-align: center;
            padding-top: 10px;
            padding-bottom: 10px;
            padding-left:50px;
            padding-right:50px;
            margin: 15px 0px 0px 15px;
            font-size: 18px;
            font-weight:bold;
            background: #10a151;
            color: #FFF;
            border: 2px solid #fff;
            outline: 0px none;
        }

        .big-poster-btn:hover {
            background: #36ba71;
        }

        .big-poster-btn:active {
            background: #109a4d;
        }

        .big-poster-back-color{
            background-color:#00a300 !important; 
        }

        .big-poster-back-color-2 {
            background-color:#2b5797 !important; 
        }

        .big-poster-back-color-3 {
            background-color:#da532c !important; 
        }

    </style>

    <div id="processing_poster" class="big-wrapper loading-big-wrapper app-back-color big-poster-back-color-2 big-poster" 
        <%= (currentInitConfStatus == SystemInitialConfigurationStatus.Configuring) ? "" : "style=\"display:none;opacity:0;\""%>>
        <div id="setting_things_msg_container" style="margin-top:10%;" class="big-poster-align-center poster-font">
            <p class="big-font-poster">
                <asp:Localize ID="Localize1" runat="server" meta:resourcekey="setting_this_up_getting_ready" />
            </p>
            <img src="<%= ResolveUrl("~/assets/img/windows-balls-line-loading.gif") %>" alt="Loading..." style="margin-top:10%;" />
        </div>
        <div id="starting_msg_container" class="big-poster-align-center poster-font" style="display:none;opacity:0;margin-top:10%;">
            <p class="big-font-poster">
                <asp:Localize ID="Localize2" runat="server" meta:resourcekey="starting" />
            </p>
            <img src="<%= ResolveUrl("~/assets/img/windows-balls-line-loading.gif") %>" alt="Loading..." style="margin-top:10%;" />
        </div>
    </div>

    <div id="resetToFactoryDefaults_poster" class="big-wrapper loading-big-wrapper app-back-color big-poster-back-color-3 big-poster" 
        <%= (currentInitConfStatus == SystemInitialConfigurationStatus.ResetToFactoryDefaults) ? "" : "style=\"display:none;opacity:0;\""%>>
        <div id="resetting_to_factory_defaults_msg_container" style="margin-top:10%;" class="big-poster-align-center poster-font">
            <p class="big-font-poster">
                <asp:Localize ID="Localize3" runat="server" meta:resourcekey="resetting_to_factory_defaults" />
            </p>
            <img src="<%= ResolveUrl("~/assets/img/windows-balls-line-loading.gif") %>" alt="Loading..." style="margin-top:10%;" />
            <p style="margin-top:3em;font-size:0.8em;"><asp:Localize runat="server" meta:resourcekey="do_not_turn_off_or_unplug" /></p>
        </div>
    </div>

    <div id="starting_poster" class="big-wrapper loading-big-wrapper app-back-color big-poster-back-color big-poster"
        <%= (currentInitConfStatus == SystemInitialConfigurationStatus.NotConfigured || currentInitConfStatus == SystemInitialConfigurationStatus.Recovering) ? "" : "style=\"display:none;opacity:0;\""%>>
        <div id="first_load_msg_container" style="margin-top:10%;" class="big-poster-align-center poster-font">
            <p class="big-font-poster">
                <asp:Localize ID="Localize4" runat="server" meta:resourcekey="getting_things_ready" />
            </p>
            <img src="<%= ResolveUrl("~/assets/img/windows-balls-line-loading.gif") %>" alt="Loading..." style="margin-top:10%;" />
        </div>
        <div id="welcome_msg_container" class="poster-font" style="display:none;opacity:0;">
            <p class="big-font-poster" style="margin-top:5%;text-indent:6.8%;">
                <asp:Localize ID="Localize5" runat="server" meta:resourcekey="nice_to_meet_you" />
            </p>
            <p style="margin-top:2.8%;text-indent:7%;font-size:1.5rem;">
                <asp:Localize ID="Localize6" runat="server" meta:resourcekey="first_steps" />
            </p>
            <ul style="font-size:1.3rem;margin-left:10%;margin-top:2.5%;">
                <li style="line-height:2;"><asp:Localize ID="Localize8" runat="server" meta:resourcekey="first_steps_1" /></li>
                <li style="line-height:2;"><asp:Localize ID="Localize9" runat="server" meta:resourcekey="first_steps_2" /></li>
            </ul>
            <div style="bottom:0;right:0;position:fixed;margin-bottom:4%;margin-right:5%;">
                <button id="starting_poster_btn" class="big-poster-btn hide">
                    <asp:Localize ID="Localize7" runat="server" meta:resourcekey="next_btn_label" />
                </button>
            </div>
        </div>
    </div>
    
    <div id="main_screen" class="row-fluid hide">
        <div class="row-fluid">
            <div class="config-view-panel" style="width:19%;">
                <legend>
                    <asp:Localize ID="Localize10" runat="server" meta:resourcekey="initial_configuration" />
                </legend>
                <div>
                    <asp:Localize ID="Localize11" runat="server" meta:resourcekey="initial_configuration_msg" />
                </div>
                <br />
                <div><asp:Localize ID="Localize12" runat="server" meta:resourcekey="initial_configuration_note" /></div>
                <div style="font-weight:bold;margin-top: 25px;">
                    <asp:Localize ID="Localize13" runat="server" meta:resourcekey="initial_configuration_requirements" />
                </div>
                <ul style="margin-top:5px;margin-left:0;list-style:none;height:170px;">
                    <li id="validation_item_network" class="validation-list-item not-valid">
                        <i name="valid" class="fa fa-check-circle"></i>
                        <i name="notValid" class="fa fa-times-circle"></i>
                        <asp:Localize ID="Localize14" runat="server" meta:resourcekey="network_configuration_label" />
                        <ul id="validation_item_network_messages_list" style="list-style-type: none; font-style: italic; height:50px;">
                        </ul>
                    </li>
                    <li id="validation_item_datetime" class="validation-list-item not-valid">
                        <i name="valid" class="fa fa-check-circle"></i>
                        <i name="notValid" class="fa fa-times-circle"></i>
                        <asp:Localize ID="Localize15" runat="server" meta:resourcekey="date_time_configuration_label" />
                        <ul id="validation_item_datetime_messages_list" style="list-style-type: none; font-style: italic; height:50px;">
                        </ul>
                    </li>
                </ul>
                <button id="start_btn" class="btn btn-primary" disabled="disabled" style="width:200px;height:50px;font-size:15px;">
                    <asp:Localize ID="Localize16" runat="server" meta:resourcekey="lets_start" />
                </button>
            </div>
            <div class="config-view-panel" style="width:51%;">
                <legend>
                    <asp:Localize ID="Localize17" runat="server" meta:resourcekey="step_1_section_title" />
                </legend>
                <div id="network_config_view"></div>
            </div>
            <div class="config-view-panel" style="width:25%;">
                <legend>
                    <asp:Localize ID="Localize18" runat="server" meta:resourcekey="step_2_section_title" />
                </legend>
                <div id="time_config_view"></div>
            </div>
        </div>
    </div>

    <script>
        Core.DOM.Ready(function () {
            try
            {
                //this is the FIRST thing that get executed in the app, the DOM Ready is called by the includer after
                //it's done loading everything it needs.

                var configPath = "<%= ResolveUrl("~/app")%>";

                window.webapp_version = "<% = version %>";

                var jam = {
                    "packages": [
                        {
                            "name": "backbone",
                            "location": "../assets/libs/jam/backbone",
                            "main": "backbone.js"
                        },
                        {
                            "name": "bootstrap-amd",
                            "location": "../assets/libs/jam/bootstrap-amd"
                        },
                        {
                            "name": "handlebars",
                            "location": "../assets/libs/jam/handlebars",
                            "main": "handlebars.js"
                        },
                        {
                            "name": "jed",
                            "location": "../assets/libs/jam/jed",
                            "main": "./jed"
                        },
                        {
                            "name": "jquery",
                            "location": "../assets/libs/jam/jquery",
                            "main": "dist/jquery.js"
                        },
                        {
                            "name": "Mousetrap",
                            "location": "../assets/libs/jam/Mousetrap",
                            "main": "mousetrap.js"
                        },
                        {
                            "name": "underscore",
                            "location": "../assets/libs/jam/underscore",
                            "main": "underscore.js"
                        }
                    ],
                    "version": "0.2.15",
                    "shim": {
                        "backbone": {
                            "deps": [
                                "underscore",
                                "jquery"
                            ],
                            "exports": "Backbone"
                        },
                        "handlebars": {
                            "exports": "Handlebars"
                        }
                    }
                };

                require.config({
                    "baseUrl": configPath,
                    "urlArgs": "<% = version %>",
                    "packages": jam.packages,
                    "shim": {
                        "backbone": {
                            "deps": [
                                "underscore",
                                "jquery"
                            ],
                            "exports": "Backbone"
                        },
                        "handlebars": {
                            "exports": "Handlebars"
                        }
                    },
                    "paths": {

                        // Defining route for the external libraries.
                        "js": "../assets/libs/js",
                        "custom-modules": "custom-modules",
                        "assets": "../assets/",
                        "custom-assets": "../custom-assets",
                    },
                });

                if (typeof exports !== "undefined" && typeof module !== "undefined") {
                    module.exports = jam;
                }

                require(["../landing/initConfig/initconfig"], function () {
                });

            }
            catch (Error) { console.error(Error); }
        });
    </script>
</asp:Content>

